/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone;

import com.jcloisterzone.PointCategory;
import com.jcloisterzone.figure.Follower;
import com.jcloisterzone.figure.Meeple;
import com.jcloisterzone.figure.Special;
import com.jcloisterzone.game.PlayerSlot;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.ui.PlayerColors;
import io.vavr.Predicates;
import io.vavr.collection.HashMap;
import io.vavr.collection.Seq;
import io.vavr.collection.Stream;
import io.vavr.collection.Vector;
import io.vavr.control.Option;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.Objects;

public class Player
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String nick;
    private final int index;
    private final PlayerSlot slot;

    public Player(String nick, int index, PlayerSlot slot) {
        this.nick = nick;
        this.index = index;
        this.slot = slot;
    }

    public String getNick() {
        return this.nick;
    }

    public int getIndex() {
        return this.index;
    }

    public PlayerSlot getSlot() {
        return this.slot;
    }

    public PlayerColors getColors() {
        return this.slot.getColors();
    }

    public boolean isLocalHuman() {
        return this.slot.isOwn() && !this.slot.isAi();
    }

    public int hashCode() {
        return Objects.hash(this.index, this.nick);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Player) {
            return this.index == ((Player)o).index;
        }
        return false;
    }

    public Player getNextPlayer(GameState state) {
        int nextPlayerIndex = (this.index + 1) % state.getPlayers().length();
        return state.getPlayers().getPlayer(nextPlayerIndex);
    }

    public Player getPrevPlayer(GameState state) {
        int prevPlayerIndex = this.index == 0 ? state.getPlayers().length() - 1 : this.index - 1;
        return state.getPlayers().getPlayer(prevPlayerIndex);
    }

    public int getPoints(GameState state) {
        return state.getPlayers().getScore().get(this.index).getPoints();
    }

    public int getPointsInCategory(GameState state, PointCategory cat) {
        HashMap<PointCategory, Integer> pointStats = state.getPlayers().getScore().get(this.getIndex()).getStats();
        Option<Integer> points = pointStats.get(cat);
        return points.getOrElse(0);
    }

    public Seq<Follower> getFollowers(GameState state) {
        return state.getPlayers().getFollowers().get(this.index);
    }

    public Seq<Special> getSpecialMeeples(GameState state) {
        return state.getPlayers().getSpecialMeeples().get(this.index);
    }

    public Stream<Meeple> getMeeples(GameState state) {
        return Stream.concat(this.getFollowers(state), this.getSpecialMeeples(state));
    }

    public boolean hasSpecialMeeple(GameState state, Class<? extends Special> clazz) {
        assert (!Modifier.isAbstract(clazz.getModifiers()));
        return !Stream.ofAll(this.getSpecialMeeples(state)).filter(m -> m.getClass().equals(clazz)).filter(m -> m.isInSupply(state)).isEmpty();
    }

    public boolean hasFollower(GameState state) {
        return !Stream.ofAll(this.getFollowers(state)).filter(m -> m.isInSupply(state)).isEmpty();
    }

    public boolean hasFollower(GameState state, Class<? extends Follower> clazz) {
        assert (!Modifier.isAbstract(clazz.getModifiers()));
        return !Stream.ofAll(this.getFollowers(state)).filter(m -> m.getClass().equals(clazz)).filter(m -> m.isInSupply(state)).isEmpty();
    }

    public <T extends Meeple> T getMeepleFromSupply(GameState state, Class<T> clazz) {
        assert (!Modifier.isAbstract(clazz.getModifiers()));
        Seq<Meeple> collection = Follower.class.isAssignableFrom(clazz) ? this.getFollowers(state) : this.getSpecialMeeples(state);
        return (T)((Meeple)Stream.ofAll(collection).filter(m -> m.getClass().equals(clazz)).find(m -> m.isInSupply(state)).getOrNull());
    }

    public Meeple getMeepleFromSupply(GameState state, String meepleId) {
        return (Meeple)Stream.ofAll(this.getMeeples(state)).find(m -> m.getId().equals(meepleId)).filter(m -> m.isInSupply(state)).getOrNull();
    }

    public Vector<Meeple> getMeeplesFromSupply(GameState state, Vector<Class<? extends Meeple>> meepleTypes) {
        return ((Vector)meepleTypes.map(cls -> this.getMeepleFromSupply(state, (Class)cls))).filter(Predicates.isNotNull());
    }

    public String toString() {
        return this.nick;
    }
}

