/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.action;

import com.jcloisterzone.action.SelectFeatureAction;
import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.figure.Meeple;
import com.jcloisterzone.ui.annotations.LinkedGridLayer;
import com.jcloisterzone.ui.grid.layer.FeatureAreaLayer;
import com.jcloisterzone.wsio.message.DeployFlierMessage;
import com.jcloisterzone.wsio.message.DeployMeepleMessage;
import com.jcloisterzone.wsio.message.WsInGameMessage;
import io.vavr.Tuple2;
import io.vavr.collection.HashMap;
import io.vavr.collection.HashSet;
import io.vavr.collection.Map;
import io.vavr.collection.Set;
import java.lang.invoke.LambdaMetafactory;
import java.util.function.Predicate;

@LinkedGridLayer(value=FeatureAreaLayer.class)
public class MeepleAction
implements SelectFeatureAction {
    private static final long serialVersionUID = 1L;
    private final Map<String, Set<FeaturePointer>> options;
    private final Class<? extends Meeple> meepleType;
    private final boolean cityOfCarcassoneMove;

    public MeepleAction(Meeple meeple, Set<FeaturePointer> options) {
        this(meeple.getClass(), HashMap.of(meeple.getId(), options), false);
    }

    public MeepleAction(Meeple meeple, Set<FeaturePointer> options, boolean cityOfCarcassoneMove) {
        this(meeple.getClass(), HashMap.of(meeple.getId(), options), cityOfCarcassoneMove);
    }

    public MeepleAction(Class<? extends Meeple> meepleType, Map<String, Set<FeaturePointer>> options, boolean cityOfCarcassoneMove) {
        this.options = options;
        this.meepleType = meepleType;
        this.cityOfCarcassoneMove = cityOfCarcassoneMove;
    }

    public Class<? extends Meeple> getMeepleType() {
        return this.meepleType;
    }

    public boolean isCityOfCarcassoneMove() {
        return this.cityOfCarcassoneMove;
    }

    public String getMeepleIdFor(FeaturePointer fp) {
        return (String)this.options.find((Predicate<Tuple2>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getMeepleIdFor$0(com.jcloisterzone.board.pointer.FeaturePointer io.vavr.Tuple2 ), (Lio/vavr/Tuple2;)Z)((FeaturePointer)fp)).get()._1;
    }

    @Override
    public WsInGameMessage select(FeaturePointer fp) {
        if (fp.getLocation() == Location.FLYING_MACHINE) {
            return new DeployFlierMessage(fp, this.getMeepleIdFor(fp));
        }
        return new DeployMeepleMessage(fp, this.getMeepleIdFor(fp));
    }

    @Override
    public Set<FeaturePointer> getOptions() {
        return this.options.values().foldLeft(HashSet.empty(), (res, o) -> res.union((Set)o));
    }

    @Override
    public boolean isEmpty() {
        return this.options.values().foldLeft(true, (res, o) -> res != false && o.isEmpty());
    }

    public String toString() {
        return "place " + this.meepleType.getSimpleName();
    }

    public MeepleAction merge(MeepleAction ma) {
        assert (ma.meepleType.equals(this.meepleType));
        assert (ma.cityOfCarcassoneMove == this.cityOfCarcassoneMove);
        Map<String, Set<FeaturePointer>> options = this.options;
        for (Tuple2 tuple2 : ma.options) {
            Set fps = options.get((String)tuple2._1).getOrElse(HashSet.empty());
            options = options.put((String)tuple2._1, fps.addAll((Iterable)tuple2._2));
        }
        return new MeepleAction(this.meepleType, options, this.cityOfCarcassoneMove);
    }

    private static /* synthetic */ boolean lambda$getMeepleIdFor$0(FeaturePointer fp, Tuple2 t) {
        return ((Set)t._2).contains(fp);
    }
}

