/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.action;

import com.jcloisterzone.action.AbstractPlayerAction;
import com.jcloisterzone.board.PlacementOption;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.Rotation;
import com.jcloisterzone.board.Tile;
import com.jcloisterzone.ui.annotations.LinkedGridLayer;
import com.jcloisterzone.ui.grid.layer.TilePlacementLayer;
import com.jcloisterzone.wsio.message.PlaceTileMessage;
import com.jcloisterzone.wsio.message.WsInGameMessage;
import io.vavr.collection.Set;
import io.vavr.collection.Stream;

@LinkedGridLayer(value=TilePlacementLayer.class)
public class TilePlacementAction
extends AbstractPlayerAction<PlacementOption> {
    private static final long serialVersionUID = 1L;
    private final Tile tile;

    public TilePlacementAction(Tile tile, Set<PlacementOption> options) {
        super(options);
        this.tile = tile;
    }

    public Tile getTile() {
        return this.tile;
    }

    @Deprecated
    public Set<Rotation> getRotations(Position pos) {
        return Stream.ofAll(this.getOptions()).filter(tp -> tp.getPosition().equals(pos)).map(tp -> tp.getRotation()).toSet();
    }

    @Override
    public WsInGameMessage select(PlacementOption tp) {
        return new PlaceTileMessage(this.tile.getId(), tp.getRotation(), tp.getPosition());
    }

    public String toString() {
        return "place tile " + this.tile.getId();
    }
}

