/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ai;

import com.jcloisterzone.Player;
import com.jcloisterzone.action.PlayerAction;
import com.jcloisterzone.game.GameSetup;
import com.jcloisterzone.game.SupportedSetup;
import com.jcloisterzone.game.state.ActionsState;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.wsio.message.PassMessage;
import com.jcloisterzone.wsio.message.WsInGameMessage;
import io.vavr.Function1;
import io.vavr.collection.IndexedSeq;
import io.vavr.collection.Vector;

public interface AiPlayer
extends Function1<GameState, WsInGameMessage> {
    default public SupportedSetup supportedSetup() {
        return SupportedSetup.getCurrentClientSupported();
    }

    default public void onGameStart(GameSetup setup, Player me) {
    }

    default public Vector<WsInGameMessage> getPossibleActions(GameState state) {
        ActionsState as = state.getPlayerActions();
        IndexedSeq messages = as.getActions().flatMap(action -> action.getOptions().map(o -> Helpers.createMessage(action, o)).toVector());
        if (as.isPassAllowed()) {
            messages = ((Vector)messages).append(new PassMessage());
        }
        return messages;
    }

    public static class Helpers {
        public static WsInGameMessage createMessage(PlayerAction action, Object option) {
            return action.select(option);
        }
    }
}

