/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ai;

import com.jcloisterzone.Player;
import com.jcloisterzone.ai.AiPlayer;
import com.jcloisterzone.ai.GameStateRanking;
import com.jcloisterzone.game.GameSetup;
import com.jcloisterzone.game.GameStatePhaseReducer;
import com.jcloisterzone.game.capability.PortalCapability;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.wsio.message.PlaceTileMessage;
import com.jcloisterzone.wsio.message.WsInGameMessage;
import com.jcloisterzone.wsio.message.WsSaltMessage;
import io.vavr.Tuple2;
import io.vavr.collection.AbstractQueue;
import io.vavr.collection.IndexedSeq;
import io.vavr.collection.Queue;
import io.vavr.collection.Vector;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RankingAiPlayer
implements AiPlayer {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private GameStateRanking stateRanking;
    private GameStatePhaseReducer phaseReducer;
    private Player me;
    private Vector<WsInGameMessage> messages = Vector.empty();

    protected abstract GameStateRanking createStateRanking(Player var1);

    @Override
    public void onGameStart(GameSetup setup, Player me) {
        this.me = me;
        this.phaseReducer = new GameStatePhaseReducer(setup, 0L);
        this.stateRanking = this.createStateRanking(me);
    }

    @Override
    public WsInGameMessage apply(GameState state) {
        if (this.messages.isEmpty()) {
            Double bestSoFar = Double.NEGATIVE_INFINITY;
            AbstractQueue queue = Queue.of(new Tuple2(state, Vector.empty()));
            while (!queue.isEmpty()) {
                Tuple2 t = queue.dequeue();
                queue = (Queue)t._2;
                Tuple2 item = (Tuple2)t._1;
                GameState itemState = (GameState)item._1;
                for (WsInGameMessage msg : this.getPossibleActions(itemState)) {
                    boolean end;
                    IndexedSeq chain = ((Vector)item._2).append(msg);
                    GameState newState = this.phaseReducer.apply(itemState, msg);
                    boolean bl = end = newState.getActivePlayer() != this.me || newState.getTurnPlayer() != state.getTurnPlayer() || msg instanceof WsSaltMessage;
                    if (!end && msg instanceof PlaceTileMessage && newState.getLastPlaced().getTile().hasModifier(PortalCapability.MAGIC_PORTAL)) {
                        end = true;
                    }
                    if (end) {
                        Double ranking = (Double)this.stateRanking.apply(newState);
                        if (!(ranking > bestSoFar)) continue;
                        bestSoFar = ranking;
                        this.messages = chain;
                        continue;
                    }
                    queue = queue.enqueue(new Tuple2<GameState, IndexedSeq>(newState, chain));
                }
            }
            if (this.logger.isDebugEnabled()) {
                String chainStr = this.messages.map(_msg -> _msg.getClass().getSimpleName()).toJavaStream().collect(Collectors.joining(", "));
                this.logger.debug(String.format("Best ranking %s, %s", bestSoFar, chainStr));
            }
        }
        WsInGameMessage msg = (WsInGameMessage)this.messages.get();
        this.messages = this.messages.drop(1);
        return msg;
    }
}

