/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ai.player;

import com.jcloisterzone.Player;
import com.jcloisterzone.feature.Completable;
import com.jcloisterzone.game.state.GameState;
import io.vavr.Tuple2;
import io.vavr.collection.HashMap;
import io.vavr.collection.HashSet;
import io.vavr.collection.Set;

public class CompletableRanking {
    private final Completable feature;
    private final int incompletePoints;
    private final int completePoints;
    private Set<Player> owners;
    private int ownersPower;
    private HashMap<Player, Integer> powers;
    private double probability;

    public CompletableRanking(GameState state, Completable feature) {
        this.feature = feature;
        this.incompletePoints = feature.getStructurePoints(state, false);
        this.completePoints = feature.getStructurePoints(state, true);
        this.powers = feature.getPowers(state).mapValues(Tuple2::_1);
        this.ownersPower = this.powers.values().max().getOrElse(0);
        this.owners = this.ownersPower == 0 ? HashSet.empty() : this.powers.keySet().filter(p -> this.powers.get((Player)p).get() == this.ownersPower);
    }

    public Completable getFeature() {
        return this.feature;
    }

    public int getCompletePoints() {
        return this.completePoints;
    }

    public int getIncompletePoints() {
        return this.incompletePoints;
    }

    public double getProbability() {
        return this.probability;
    }

    public void setProbability(double probability) {
        this.probability = probability;
    }

    public Set<Player> getOwners() {
        return this.owners;
    }

    public int getOwnersPower() {
        return this.ownersPower;
    }

    public void setOwners(Set<Player> owners) {
        this.owners = owners;
    }

    public HashMap<Player, Integer> getPowers() {
        return this.powers;
    }

    public void setPowers(HashMap<Player, Integer> powers) {
        this.powers = powers;
    }
}

