/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ai.player;

import com.jcloisterzone.Player;
import com.jcloisterzone.ai.GameStateRanking;
import com.jcloisterzone.ai.player.CompletableRanking;
import com.jcloisterzone.board.Edge;
import com.jcloisterzone.board.EdgePattern;
import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.Rotation;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.feature.City;
import com.jcloisterzone.feature.CloisterLike;
import com.jcloisterzone.feature.Completable;
import com.jcloisterzone.feature.CompletableFeature;
import com.jcloisterzone.feature.Farm;
import com.jcloisterzone.feature.Road;
import com.jcloisterzone.figure.Barn;
import com.jcloisterzone.figure.Follower;
import com.jcloisterzone.figure.Meeple;
import com.jcloisterzone.figure.SmallFollower;
import com.jcloisterzone.game.ScoreFeatureReducer;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.game.state.PlacedTile;
import com.jcloisterzone.game.state.PlayersState;
import com.jcloisterzone.reducers.ScoreFarm;
import com.jcloisterzone.reducers.ScoreFarmBarn;
import io.vavr.Predicates;
import io.vavr.Tuple2;
import io.vavr.collection.HashMap;
import io.vavr.collection.LinearSeq;
import io.vavr.collection.Map;
import io.vavr.collection.Set;
import io.vavr.collection.Stream;
import io.vavr.collection.Traversable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LegacyRanking
implements GameStateRanking {
    protected final transient Logger logger = LoggerFactory.getLogger("AI Ranking");
    public static final double[] OPEN_ROAD_PENALTY = new double[]{0.0, 1.0, 2.5, 4.5, 7.5, 10.5, 14.5, 19.0, 29.0};
    public static final double[] OPEN_CITY_PENALTY = new double[]{0.0, 0.5, 1.5, 3.0, 5.0, 8.0, 12.0, 17.0, 27.0};
    public static final double[] OPEN_FARM_PENALTY = new double[]{0.0, 5.0, 10.0, 19.0, 28.0, 37.0, 47.0, 57.0, 67.0};
    public static final double[] OPEN_CLOISTER_PENALTY = new double[]{0.0, 0.0, 0.4, 0.8, 1.2, 2.0, 4.0, 7.0, 11.0};
    private final Player me;
    private GameState state;
    private int numberOfPlayers;
    private int remainingTurns;
    private PlacedTile lastPlaced;
    private Map<Position, Double> positionProbability;
    private java.util.HashMap<Edge, CompletableRanking> edges;
    private List<CompletableRanking> occupiedCompletables;
    private List<ScoreFeatureReducer> occupiedFarms;

    public LegacyRanking(Player me) {
        this.me = me;
    }

    @Override
    public Double apply(GameState state) {
        double ranking = 0.0;
        this.state = state;
        this.numberOfPlayers = state.getPlayers().length();
        this.lastPlaced = state.getLastPlaced();
        this.positionProbability = this.getPositionProbability();
        this.remainingTurns = (int)Math.ceil(state.getTilePack().totalSize() / this.numberOfPlayers);
        this.edges = new java.util.HashMap();
        this.occupiedCompletables = new ArrayList<CompletableRanking>();
        this.occupiedFarms = new ArrayList<ScoreFeatureReducer>();
        this.logger.debug("--> {}", (Object)this.lastPlaced);
        double r = this.ratePoints();
        ranking += r;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("  > Points              %8.5f", r));
        }
        r = this.rateUnfinishedFeatures();
        ranking += r;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("  > Unfinished features       %8.5f", r));
        }
        r = this.rateOpenFeatures();
        ranking += r;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("  > Open features       %8.5f", r));
        }
        r = this.rateMeeples();
        ranking += r;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("  > Meeples             %8.5f", r));
        }
        r = this.rateBoardShape();
        ranking += r;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("  > Board shape         %8.5f", r));
        }
        r = this.rateDragon();
        ranking += r;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("  > Dragon              %8.5f", r));
        }
        r = this.rateConnections();
        ranking += r;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("  > Connections         %8.5f", r));
            this.logger.debug(String.format("--> Total               %8.5f", ranking));
        }
        return ranking;
    }

    private double ptsforPlayer(Player p, double pts) {
        return p == this.me ? pts : -pts;
    }

    private Map<Position, Double> getPositionProbability() {
        Map<EdgePattern, Integer> packPatterns = this.state.getTilePack().getPatterns();
        return this.state.getAvailablePlacements().toMap(avail -> {
            int matchingTiles = 0;
            for (Tuple2 pattern : packPatterns) {
                if (!((EdgePattern)avail._2).isMatchingAnyRotation((EdgePattern)pattern._1)) continue;
                matchingTiles += ((Integer)pattern._2).intValue();
            }
            double prob = 0.0;
            if (matchingTiles > 0) {
                prob = 1.0 - Math.pow(1.0 - 1.0 / (double)this.numberOfPlayers, matchingTiles);
            }
            return new Tuple2<Position, Double>((Position)avail._1, prob);
        });
    }

    private double ratePoints() {
        double r = 0.0;
        PlayersState ps = this.state.getPlayers();
        for (Player player : ps.getPlayers()) {
            r += this.ptsforPlayer(player, ps.getScore().get(player.getIndex()).getPoints());
        }
        return r;
    }

    private double countCompleteProbability(Completable completable) {
        double prob = 1.0;
        LinearSeq adjacent = null;
        if (completable instanceof CloisterLike) {
            CloisterLike cl = (CloisterLike)completable;
            Position pos = (Position)cl.getTilePositions().get();
            adjacent = Stream.ofAll(Position.ADJACENT_AND_DIAGONAL.values()).map(offset -> pos.add((Position)offset)).filter(p -> this.positionProbability.containsKey((Position)p));
        } else if (completable instanceof CompletableFeature) {
            CompletableFeature cf = (CompletableFeature)completable;
            adjacent = Stream.ofAll(cf.getOpenEdges().map(edge -> {
                if (this.positionProbability.containsKey(edge.getP1())) {
                    return edge.getP1();
                }
                return edge.getP2();
            }));
        }
        if (adjacent != null) {
            prob = adjacent.map(p -> (Double)this.positionProbability.get((Position)p).getOrNull()).foldLeft(1.0, (res, p) -> res * p);
        }
        return prob;
    }

    private double getCompletablePoints(CompletableRanking cr) {
        double prob = cr.getProbability();
        if (prob > 0.85) {
            prob = 1.0;
        }
        if (cr.getFeature() instanceof CloisterLike) {
            int uncertain = 9 - cr.getIncompletePoints();
            return (double)cr.getIncompletePoints() + prob * 0.5 * (double)uncertain;
        }
        int uncertain = cr.getCompletePoints() - cr.getIncompletePoints();
        return (double)cr.getIncompletePoints() + prob * 0.8 * (double)uncertain;
    }

    private double rateOpenFeatures() {
        double r = 0.0;
        for (Player player : this.state.getPlayers().getPlayers()) {
            int cloisters = 0;
            int roads = 0;
            int cities = 0;
            int farms = 0;
            for (CompletableRanking cr : this.occupiedCompletables) {
                Set<Player> owners = cr.getOwners();
                if (owners.size() != 1 || owners.get() != player) continue;
                if (cr.getFeature() instanceof CloisterLike) {
                    ++cloisters;
                    continue;
                }
                if (cr.getFeature() instanceof Road) {
                    ++roads;
                    continue;
                }
                if (!(cr.getFeature() instanceof City)) continue;
                ++cities;
            }
            for (ScoreFeatureReducer sfr : this.occupiedFarms) {
                if (!sfr.getOwners().contains(player)) continue;
                ++farms;
            }
            double pr = 0.0;
            pr -= OPEN_ROAD_PENALTY[roads];
            pr -= OPEN_CITY_PENALTY[cities];
            pr -= OPEN_CLOISTER_PENALTY[cloisters];
            r += this.ptsforPlayer(player, pr -= OPEN_FARM_PENALTY[farms]);
        }
        return r;
    }

    private double rateUnfinishedFeatures() {
        double r = 0.0;
        for (Completable completable : this.state.getFeatures(Completable.class)) {
            CompletableRanking cr = new CompletableRanking(this.state, completable);
            double fr = 0.0;
            if (completable instanceof CompletableFeature) {
                CompletableFeature cf = (CompletableFeature)completable;
                for (Edge edge : cf.getOpenEdges()) {
                    this.edges.put(edge, cr);
                }
                this.occupiedCompletables.add(cr);
            }
            double prob = this.countCompleteProbability(completable);
            cr.setProbability(prob);
            Tuple2<Double, Double> penalty = null;
            if (prob < 1.0E-4) {
                penalty = new Tuple2<Double, Double>(12.0, 3.0);
            } else if (prob < 0.2) {
                penalty = new Tuple2<Double, Double>(3.0, 0.75);
            } else if (prob < 0.55) {
                penalty = new Tuple2<Double, Double>(1.2, 0.3);
            }
            if (this.remainingTurns > 7 && penalty != null) {
                for (Follower follower : completable.getFollowers(this.state)) {
                    if (follower.getPlayer() == this.me) {
                        fr -= ((Double)penalty._1).doubleValue();
                        continue;
                    }
                    fr += ((Double)penalty._2).doubleValue();
                }
            }
            double points = this.getCompletablePoints(cr);
            for (Player player : cr.getOwners()) {
                fr += this.ptsforPlayer(player, points);
            }
            r += fr;
        }
        for (Farm farm : this.state.getFeatures(Farm.class)) {
            boolean hasBarn = farm.getSpecialMeeples(this.state).find(Predicates.instanceOf(Barn.class)).isDefined();
            ScoreFeatureReducer sr = hasBarn ? new ScoreFarmBarn(farm, true) : new ScoreFarm(farm, true);
            sr.apply(this.state);
            this.occupiedFarms.add(sr);
            for (Player player : sr.getOwners()) {
                double q = 0.99;
                if (player != this.me) {
                    q = -q;
                }
                r += q * (double)sr.getFeaturePoints(player);
            }
        }
        return r;
    }

    private double rateMeeples() {
        double r = 0.0;
        for (Player player : this.state.getPlayers().getPlayers()) {
            double q = player == this.me ? 1.0 : -1.0;
            int inSupply = 0;
            for (Follower f2 : player.getFollowers(this.state).filter(f -> f.isInSupply(this.state))) {
                r = f2.getClass().equals(SmallFollower.class) ? (r += q * 0.15) : (r += q * 0.25);
                ++inSupply;
            }
            if (inSupply != 0) continue;
            r += this.ptsforPlayer(player, -4.0);
        }
        return r;
    }

    private double rateDragon() {
        Position pos = this.state.getNeutralFigures().getDragonDeployment();
        if (pos == null) {
            return 0.0;
        }
        double r = 0.0;
        for (Tuple2 tuple2 : this.state.getDeployedMeeples()) {
            int dist = ((FeaturePointer)tuple2._2).getPosition().squareDistance(pos);
            if (dist > 3) continue;
            r -= this.ptsforPlayer(((Meeple)tuple2._1).getPlayer(), 3 - dist);
        }
        return r;
    }

    private double rateBoardShape() {
        return 1.0E-4 * (double)this.state.getAdjacentTiles2(this.lastPlaced.getPosition()).size();
    }

    private HashMap<Player, Integer> getCombinedPowers(CompletableRanking r1, CompletableRanking r2) {
        Map<Player, Integer> combinedPowers = r1.getPowers();
        for (Tuple2 tuple2 : r2.getPowers()) {
            int p = combinedPowers.get((Player)tuple2._1).getOrElse(0);
            combinedPowers = combinedPowers.put((Object)((Player)tuple2._1), (Object)(p + (Integer)tuple2._2));
        }
        return combinedPowers;
    }

    private double rateConnection(Edge e1, Edge e2, double prob) {
        CompletableRanking r1 = this.edges.get(e1);
        CompletableRanking r2 = this.edges.get(e2);
        if (r1 == null || r2 == null || !r1.getFeature().getClass().equals(r2.getFeature().getClass())) {
            return 0.0;
        }
        if (r2.getOwnersPower() > r1.getOwnersPower()) {
            CompletableRanking tmp = r2;
            r2 = r1;
            r1 = tmp;
        }
        if (r1.getOwnersPower() == 0) {
            return 0.0;
        }
        HashMap<Player, Integer> combinedPowers = this.getCombinedPowers(r1, r2);
        int combinedMaxPower = combinedPowers.values().max().getOrElse(0);
        Traversable combinedOwners = combinedPowers.keySet().filter(p -> (Integer)combinedPowers.get((Player)p).get() == combinedMaxPower);
        Set<Player> loss1 = r1.getOwners().diff((Set<Player>)combinedOwners);
        Set<Player> loss2 = r2.getOwners().diff((Set<Player>)combinedOwners);
        Set<Player> gain1 = combinedOwners.diff(r1.getOwners());
        Set<Player> gain2 = combinedOwners.diff(r2.getOwners());
        double featurePoints1 = this.getCompletablePoints(r1);
        double featurePoints2 = this.getCompletablePoints(r2);
        double points1 = 0.5 * prob * featurePoints1;
        double points2 = 0.5 * prob * featurePoints2;
        double r = 0.0;
        for (Player p2 : loss1) {
            r -= this.ptsforPlayer(p2, points1);
        }
        for (Player p2 : loss2) {
            r -= this.ptsforPlayer(p2, points2);
        }
        for (Player p2 : gain1) {
            r += this.ptsforPlayer(p2, points1);
        }
        for (Player p2 : gain2) {
            r += this.ptsforPlayer(p2, points2);
        }
        return r;
    }

    private double rateConnections() {
        double r = 0.0;
        for (Tuple2 tuple2 : this.positionProbability) {
            if ((Double)tuple2._2 < 0.55) continue;
            Position pos = (Position)tuple2._1;
            for (Location loc : Location.SIDES) {
                r += this.rateConnection(new Edge(pos, loc), new Edge(pos, loc.rotateCW(Rotation.R90)), (Double)tuple2._2);
            }
        }
        return r;
    }
}

