/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.board;

import com.jcloisterzone.board.EdgeType;
import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Rotation;
import com.jcloisterzone.board.TileSymmetry;
import io.vavr.collection.Map;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

public class EdgePattern
implements Serializable {
    private static final long serialVersionUID = 1L;
    int mask;

    public EdgePattern(int mask) {
        this.mask = mask;
    }

    public EdgePattern(EdgeType N, EdgeType E, EdgeType S, EdgeType W) {
        this.mask = N.getMask() + (E.getMask() << 4) + (S.getMask() << 8) + (W.getMask() << 12);
    }

    public EdgePattern(Map<Location, EdgeType> edges) {
        this(edges.get(Location.N).get(), edges.get(Location.E).get(), edges.get(Location.S).get(), edges.get(Location.W).get());
    }

    public static EdgePattern fromString(String str) {
        if (str.length() != 4) {
            throw new IllegalArgumentException();
        }
        return new EdgePattern(EdgeType.forChar(str.charAt(0)), EdgeType.forChar(str.charAt(1)), EdgeType.forChar(str.charAt(2)), EdgeType.forChar(str.charAt(3)));
    }

    public EdgeType[] getEdges() {
        return new EdgeType[]{EdgeType.forMask(this.mask & 0xF), EdgeType.forMask(this.mask >> 4 & 0xF), EdgeType.forMask(this.mask >> 8 & 0xF), EdgeType.forMask(this.mask >> 12 & 0xF)};
    }

    public TileSymmetry getSymmetry() {
        EdgeType[] edges = this.getEdges();
        if (edges[0] == edges[1] && edges[0] == edges[2] && edges[0] == edges[3]) {
            return TileSymmetry.S4;
        }
        if (edges[0] == edges[2] && edges[1] == edges[3]) {
            return TileSymmetry.S2;
        }
        return TileSymmetry.NONE;
    }

    public EdgeType at(Location loc) {
        if (loc == Location.N) {
            return EdgeType.forMask(this.mask & 0xF);
        }
        if (loc == Location.E) {
            return EdgeType.forMask(this.mask >> 4 & 0xF);
        }
        if (loc == Location.S) {
            return EdgeType.forMask(this.mask >> 8 & 0xF);
        }
        if (loc == Location.W) {
            return EdgeType.forMask(this.mask >> 12 & 0xF);
        }
        throw new IllegalArgumentException();
    }

    public EdgePattern rotate(Rotation rot) {
        if (rot == Rotation.R0) {
            return this;
        }
        List<EdgeType> l = Arrays.asList(this.getEdges());
        Collections.rotate(l, rot.ordinal());
        return new EdgePattern(l.get(0), l.get(1), l.get(2), l.get(3));
    }

    public EdgePattern replace(Location loc, EdgeType type) {
        return new EdgePattern(loc == Location.N ? type : this.at(Location.N), loc == Location.E ? type : this.at(Location.E), loc == Location.S ? type : this.at(Location.S), loc == Location.W ? type : this.at(Location.W));
    }

    @Deprecated
    public EdgeType at(Location loc, Rotation rotation) {
        return this.at(loc.rotateCCW(rotation));
    }

    public int wildcardSize() {
        return (int)Stream.of(this.getEdges()).filter(edge -> edge == EdgeType.UNKNOWN).count();
    }

    public EdgePattern canonize() {
        EdgePattern min = this;
        for (Rotation rot : Rotation.values()) {
            EdgePattern ep = this.rotate(rot);
            if (ep.mask >= min.mask) continue;
            min = ep;
        }
        return min;
    }

    public boolean isMatchingExact(EdgePattern ep) {
        int m = this.mask & ep.mask;
        return (m & 0xF) != 0 && (m & 0xF0) != 0 && (m & 0xF00) != 0 && (m & 0xF000) != 0;
    }

    public boolean isMatchingAnyRotation(EdgePattern ep) {
        for (Rotation rot : Rotation.values()) {
            if (!this.rotate(rot).isMatchingExact(ep)) continue;
            return true;
        }
        return false;
    }

    public boolean isBridgeAllowed(Location bridge) {
        assert (bridge == Location.NS || bridge == Location.WE);
        if (bridge == Location.NS) {
            if (this.at(Location.N) != EdgeType.FARM) {
                return false;
            }
            if (this.at(Location.S) != EdgeType.FARM) {
                return false;
            }
        } else {
            if (this.at(Location.W) != EdgeType.FARM) {
                return false;
            }
            if (this.at(Location.E) != EdgeType.FARM) {
                return false;
            }
        }
        return true;
    }

    private EdgeType getBridgeReplacement(Location side) {
        switch (this.at(side)) {
            case FARM: {
                return EdgeType.ROAD;
            }
            case UNKNOWN: {
                return EdgeType.UNKNOWN;
            }
        }
        throw new IllegalArgumentException();
    }

    public EdgePattern getBridgePattern(Location bridge) {
        assert (bridge == Location.NS || bridge == Location.WE);
        try {
            if (bridge == Location.NS) {
                return new EdgePattern(this.getBridgeReplacement(Location.N), this.at(Location.E), this.getBridgeReplacement(Location.S), this.at(Location.W));
            }
            return new EdgePattern(this.at(Location.N), this.getBridgeReplacement(Location.E), this.at(Location.S), this.getBridgeReplacement(Location.W));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Pattern cannot be extended with " + bridge + "bridge.");
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EdgePattern)) {
            return false;
        }
        EdgePattern that = (EdgePattern)obj;
        return that.canonize().mask == this.canonize().mask;
    }

    public int hashCode() {
        return this.mask;
    }

    public String toString() {
        return String.format("%s%s%s%s", Character.valueOf(this.at(Location.N).asChar()), Character.valueOf(this.at(Location.E).asChar()), Character.valueOf(this.at(Location.S).asChar()), Character.valueOf(this.at(Location.W).asChar()));
    }
}

