/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.board;

import com.jcloisterzone.board.Corner;
import com.jcloisterzone.board.Rotation;
import io.vavr.collection.IndexedSeq;
import io.vavr.collection.List;
import io.vavr.collection.Vector;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Location
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient String name;
    private int mask;
    private static Map<Integer, Location> instances = new HashMap<Integer, Location>();
    public static final Location N = new Location("N", 768);
    public static final Location W = new Location("W", 49152);
    public static final Location S = new Location("S", 12288);
    public static final Location E = new Location("E", 3072);
    public static final Location NW = new Location("NW", 49920);
    public static final Location SW = new Location("SW", 61440);
    public static final Location SE = new Location("SE", 15360);
    public static final Location NE = new Location("NE", 3840);
    public static final Location WE = new Location("WE", 52224);
    public static final Location NS = new Location("NS", 13056);
    public static final Location NWSE = new Location("NWSE", 65280);
    public static final Location _N = new Location("_N", 64512);
    public static final Location _W = new Location("_W", 16128);
    public static final Location _S = new Location("_S", 52992);
    public static final Location _E = new Location("_E", 62208);
    public static final Location CLOISTER = new Location("CLOISTER", 262144);
    public static final Location MONASTERY = new Location("MONASTERY", 524288);
    public static final Location TOWER = new Location("TOWER", 0x100000);
    public static final Location FLYING_MACHINE = new Location("FLYING_MACHINE", 0x200000);
    public static final Location QUARTER_CASTLE = new Location("QUARTER_CASTLE", 0x400000);
    public static final Location QUARTER_MARKET = new Location("QUARTER_MARKET", 0x800000);
    public static final Location QUARTER_BLACKSMITH = new Location("QUARTER_BLACKSMITH", 0x1000000);
    public static final Location QUARTER_CATHEDRAL = new Location("QUARTER_CATHEDRAL", 0x2000000);
    public static final Location INNER_FARM = new Location("INNER_FARM", 65536);
    public static final Location INNER_FARM_B = new Location("INNER_FARM_B", 131072);
    public static final Location NL = new Location("NL", 1);
    public static final Location NR = new Location("NR", 2);
    public static final Location EL = new Location("EL", 4);
    public static final Location ER = new Location("ER", 8);
    public static final Location SL = new Location("SL", 16);
    public static final Location SR = new Location("SR", 32);
    public static final Location WL = new Location("WL", 64);
    public static final Location WR = new Location("WR", 128);
    public static final List<Location> SIDES = List.of(N, E, S, W);
    public static final List<Location> FARM_SIDES = List.of(NL, NR, EL, ER, SL, SR, WL, WR);
    public static final List<Location> BRIDGES = List.of(NS, WE);
    public static final List<Location> QUARTERS = List.of(QUARTER_CASTLE, QUARTER_MARKET, QUARTER_BLACKSMITH, QUARTER_CATHEDRAL);

    public static Location create(int mask) {
        if (mask == 0) {
            return null;
        }
        Location loc = instances.get(mask);
        if (loc != null) {
            return loc;
        }
        return new Location(null, mask);
    }

    private Object readResolve() throws ObjectStreamException {
        return Location.create(this.mask);
    }

    public int getMask() {
        return this.mask;
    }

    private Location(String name, int mask) {
        this.name = name;
        this.mask = mask;
        instances.put(mask, this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Location)) {
            return false;
        }
        return this.mask == ((Location)obj).mask;
    }

    public int hashCode() {
        return this.mask;
    }

    public Location next() {
        return this.shift(2);
    }

    public Location prev() {
        return this.shift(6);
    }

    public Location rev() {
        int mLo = this.mask & 0xFF;
        mLo = (mLo & 0x55) << 5 | (mLo & 0xAA) << 3;
        mLo = (mLo | mLo >> 8) & 0xFF;
        int mHi = (this.mask & 0xFF00) >> 8;
        mHi = (mHi & 0x55) << 5 | (mHi & 0xAA) << 3;
        mHi = (mHi | mHi >> 8) & 0xFF;
        return Location.create(this.mask & 0xFFFF0000 | mHi << 8 | mLo);
    }

    private Location shift(int i) {
        int mLo = (this.mask & 0xFF) << i;
        mLo = (mLo | mLo >> 8) & 0xFF;
        int mHi = (this.mask & 0xFF00) << i;
        mHi = (mHi | mHi >> 8) & 0xFF00;
        return Location.create(this.mask & 0xFFFF0000 | mHi | mLo);
    }

    public Location rotateCCW(Rotation rot) {
        return this.shift(rot.ordinal() * 6 % 8);
    }

    public Location rotateCW(Rotation rot) {
        return this.shift(rot.ordinal() * 2);
    }

    public Location getLeftFarm() {
        assert (this.isEdgeLocation());
        return Location.create(this.mask >> 8 & 0x55);
    }

    public Location getRightFarm() {
        assert (this.isEdgeLocation());
        return Location.create(this.mask >> 8 & 0xAA);
    }

    public Location farmToSide() {
        assert (this.isFarmLocation());
        int mask = 0;
        if (NL.isPartOf(this)) {
            mask |= Location.N.mask;
        }
        if (NR.isPartOf(this)) {
            mask |= Location.N.mask;
        }
        if (EL.isPartOf(this)) {
            mask |= Location.E.mask;
        }
        if (ER.isPartOf(this)) {
            mask |= Location.E.mask;
        }
        if (SL.isPartOf(this)) {
            mask |= Location.S.mask;
        }
        if (SR.isPartOf(this)) {
            mask |= Location.S.mask;
        }
        if (WL.isPartOf(this)) {
            mask |= Location.W.mask;
        }
        if (WR.isPartOf(this)) {
            mask |= Location.W.mask;
        }
        return Location.create(mask);
    }

    public boolean isPartOf(Location loc) {
        if (this.mask == 0) {
            return this == loc;
        }
        return ((this.mask ^ loc.mask) & this.mask) == 0;
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        StringBuilder str = new StringBuilder();
        for (Location atom : FARM_SIDES) {
            if (this.intersect(atom) == null) continue;
            if (str.length() > 0) {
                str.append(".");
            }
            str.append(atom);
        }
        return str.toString();
    }

    public Location union(Location loc) {
        if (loc == null) {
            return this;
        }
        assert (!this.isSpecialLocation() && this.isEdgeLocation() == loc.isEdgeLocation() & this.isFarmLocation() == loc.isFarmLocation()) : "union(" + this + ',' + loc + ')';
        return Location.create(this.mask | loc.mask);
    }

    public Location subtract(Location loc) {
        if (loc == null) {
            return this;
        }
        assert (!this.isSpecialLocation() && this.isEdgeLocation() == loc.isEdgeLocation() & this.isFarmLocation() == loc.isFarmLocation()) : "subtract(" + this + ',' + loc + ')';
        return Location.create(~(this.mask & loc.mask) & this.mask);
    }

    public Location intersect(Location loc) {
        if (loc == null || (this.mask & loc.mask) == 0) {
            return null;
        }
        assert (!this.isSpecialLocation() && this.isEdgeLocation() == loc.isEdgeLocation() & this.isFarmLocation() == loc.isFarmLocation()) : "intersect(" + this + ',' + loc + ')';
        return Location.create(this.mask & loc.mask);
    }

    public List<Location> splitToSides() {
        return SIDES.filter(side -> this.intersect((Location)side) != null);
    }

    public List<Location> splitToFarmSides() {
        return FARM_SIDES.filter(side -> this.intersect((Location)side) != null);
    }

    public static Location valueOf(String name) {
        Location value = null;
        for (String part : name.split("\\.")) {
            try {
                Location item = (Location)Location.class.getField(part).get(null);
                value = item.union(value);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Unknown location " + name, ex);
            }
        }
        assert (value != null);
        return value;
    }

    public Rotation getRotationOf(Location loc) {
        for (Rotation r : Rotation.values()) {
            if (!this.equals(loc.rotateCW(r))) continue;
            return r;
        }
        return null;
    }

    public boolean isRotationOf(Location loc) {
        return this.getRotationOf(loc) != null;
    }

    public Vector<Corner> getCorners() {
        if (!this.isFarmLocation()) {
            return Vector.empty();
        }
        IndexedSeq res = Vector.empty();
        if (WR.isPartOf(this) && NL.isPartOf(this)) {
            res = ((Vector)res).append((Object)Corner.NW);
        }
        if (NR.isPartOf(this) && EL.isPartOf(this)) {
            res = ((Vector)res).append((Object)Corner.NE);
        }
        if (ER.isPartOf(this) && SL.isPartOf(this)) {
            res = ((Vector)res).append((Object)Corner.SE);
        }
        if (SR.isPartOf(this) && WL.isPartOf(this)) {
            res = ((Vector)res).append((Object)Corner.SW);
        }
        return res;
    }

    public boolean isFarmLocation() {
        return (this.mask & 0x30000 | this.mask & 0xFF) > 0;
    }

    public boolean isEdgeLocation() {
        return (this.mask & 0xFF00) > 0;
    }

    public boolean isSpecialLocation() {
        return (this.mask & 0xFFFC0000) > 0;
    }

    public boolean isBridgeLocation() {
        return BRIDGES.contains(this);
    }

    public boolean isCityOfCarcassonneQuarter() {
        return QUARTERS.contains(this);
    }
}

