/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.board;

import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.Rotation;
import com.jcloisterzone.board.pointer.FeaturePointer;
import java.util.Objects;

public class PlacementOption
implements Comparable<PlacementOption> {
    private final Position position;
    private final Rotation rotation;
    private final FeaturePointer mandatoryBridge;

    public PlacementOption(Position position, Rotation rotation, FeaturePointer mandatoryBridge) {
        this.position = position;
        this.rotation = rotation;
        this.mandatoryBridge = mandatoryBridge;
    }

    public Position getPosition() {
        return this.position;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public FeaturePointer getMandatoryBridge() {
        return this.mandatoryBridge;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append(this.position).append(",").append((Object)this.rotation);
        if (this.mandatoryBridge != null) {
            sb.append(",bridge=");
            sb.append(this.mandatoryBridge);
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.position, this.rotation, this.mandatoryBridge});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlacementOption other = (PlacementOption)obj;
        if (!Objects.equals(this.position, other.position)) {
            return false;
        }
        if (!Objects.equals((Object)this.rotation, (Object)other.rotation)) {
            return false;
        }
        return Objects.equals(this.mandatoryBridge, other.mandatoryBridge);
    }

    @Override
    public int compareTo(PlacementOption o) {
        int p = this.position.compareTo(o.position);
        if (p != 0) {
            return p;
        }
        return this.rotation.ordinal() - o.rotation.ordinal();
    }
}

