/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.board;

import java.awt.geom.AffineTransform;

public enum Rotation {
    R0,
    R90,
    R180,
    R270;


    public AffineTransform getAffineTransform(int size) {
        return this.getAffineTransform(size, size);
    }

    public AffineTransform getAffineTransform(int sizeX, int sizeY) {
        switch (this.ordinal()) {
            case 0: {
                AffineTransform at = new AffineTransform();
                return at;
            }
            case 1: {
                AffineTransform at = AffineTransform.getRotateInstance(1.5707963267948966);
                at.translate(0.0, -sizeY);
                return at;
            }
            case 2: {
                AffineTransform at = AffineTransform.getRotateInstance(Math.PI);
                at.translate(-sizeX, -sizeY);
                return at;
            }
            case 3: {
                AffineTransform at = AffineTransform.getRotateInstance(4.71238898038469);
                at.translate(-sizeX, 0.0);
                return at;
            }
        }
        return null;
    }

    public Rotation next() {
        return Rotation.values()[(this.ordinal() + 1) % Rotation.values().length];
    }

    public Rotation prev() {
        return Rotation.values()[(this.ordinal() - 1) % Rotation.values().length];
    }

    public double getTheta() {
        return (double)this.ordinal() * Math.PI / 2.0;
    }

    public Rotation add(Rotation r) {
        return Rotation.values()[(this.ordinal() + r.ordinal()) % Rotation.values().length];
    }

    public Rotation inverse() {
        switch (this.ordinal()) {
            case 0: {
                return R0;
            }
            case 1: {
                return R270;
            }
            case 2: {
                return R180;
            }
            case 3: {
                return R90;
            }
        }
        throw new IllegalStateException();
    }
}

