/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.board;

import com.google.common.base.Objects;
import com.jcloisterzone.Expansion;
import com.jcloisterzone.board.EdgePattern;
import com.jcloisterzone.board.EdgeType;
import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.TileModifier;
import com.jcloisterzone.board.TileSymmetry;
import com.jcloisterzone.feature.Bridge;
import com.jcloisterzone.feature.City;
import com.jcloisterzone.feature.Feature;
import com.jcloisterzone.feature.River;
import com.jcloisterzone.feature.Road;
import io.vavr.Tuple2;
import io.vavr.collection.HashSet;
import io.vavr.collection.Map;
import io.vavr.collection.Set;
import java.io.Serializable;

public class Tile
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Expansion origin;
    private final String id;
    private final EdgePattern edgePattern;
    private final TileSymmetry symmetry;
    private final Map<Location, Feature> initialFeatures;
    private final Set<TileModifier> modifiers;

    public Tile(Expansion origin, String id, Map<Location, Feature> initialFeatures) {
        this(origin, id, initialFeatures, HashSet.empty());
    }

    public Tile(Expansion origin, String id, Map<Location, Feature> initialFeatures, Set<TileModifier> modifiers) {
        this.origin = origin;
        this.id = id;
        this.initialFeatures = initialFeatures;
        this.modifiers = modifiers;
        this.edgePattern = this.computeEdgePattern();
        this.symmetry = this.edgePattern.getSymmetry();
    }

    public Tile addTileModifier(TileModifier modifier) {
        return new Tile(this.origin, this.id, this.initialFeatures, this.modifiers.add(modifier));
    }

    public Tile setInitialFeatures(Map<Location, Feature> initialFeatures) {
        return new Tile(this.origin, this.id, initialFeatures, this.modifiers);
    }

    public Tile addBridge(Location bridgeLoc) {
        assert (bridgeLoc == Location.NS || bridgeLoc == Location.WE);
        Bridge bridge = new Bridge(bridgeLoc);
        return this.setInitialFeatures(this.initialFeatures.put(bridgeLoc, bridge));
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.initialFeatures);
    }

    public Expansion getOrigin() {
        return this.origin;
    }

    public String getId() {
        return this.id;
    }

    public EdgePattern getEdgePattern() {
        return this.edgePattern;
    }

    public TileSymmetry getSymmetry() {
        return this.symmetry;
    }

    public Map<Location, Feature> getInitialFeatures() {
        return this.initialFeatures;
    }

    public Set<TileModifier> getTileModifiers() {
        return this.modifiers;
    }

    public boolean hasModifier(TileModifier modifier) {
        return this.modifiers.contains(modifier);
    }

    public boolean hasTower() {
        return this.initialFeatures.containsKey(Location.TOWER);
    }

    private EdgeType computeSideEdge(Location loc) {
        Tuple2 tuple = (Tuple2)this.initialFeatures.find(item -> loc.isPartOf((Location)item._1)).getOrNull();
        if (tuple == null) {
            return EdgeType.FARM;
        }
        if (tuple._2 instanceof Road) {
            return EdgeType.ROAD;
        }
        if (tuple._2 instanceof City) {
            return EdgeType.CITY;
        }
        if (tuple._2 instanceof River) {
            return EdgeType.RIVER;
        }
        throw new IllegalArgumentException();
    }

    private EdgePattern computeEdgePattern() {
        return new EdgePattern(this.computeSideEdge(Location.N), this.computeSideEdge(Location.E), this.computeSideEdge(Location.S), this.computeSideEdge(Location.W));
    }

    public String toString() {
        return this.id;
    }
}

