/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.board;

import com.jcloisterzone.Expansion;
import com.jcloisterzone.XMLUtils;
import com.jcloisterzone.board.Edge;
import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.ShortEdge;
import com.jcloisterzone.board.Tile;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.feature.City;
import com.jcloisterzone.feature.Cloister;
import com.jcloisterzone.feature.Farm;
import com.jcloisterzone.feature.Feature;
import com.jcloisterzone.feature.River;
import com.jcloisterzone.feature.Road;
import com.jcloisterzone.feature.Tower;
import com.jcloisterzone.game.Capability;
import com.jcloisterzone.game.state.GameState;
import io.vavr.Tuple2;
import io.vavr.Tuple3;
import io.vavr.collection.HashMap;
import io.vavr.collection.HashSet;
import io.vavr.collection.LinearSeq;
import io.vavr.collection.Set;
import io.vavr.collection.Stream;
import io.vavr.collection.Vector;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TileBuilder {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<Location, Feature> features;
    private List<Tuple3<ShortEdge, Location, FeaturePointer>> multiEdges;
    private String tileId;
    private GameState state;

    public GameState getGameState() {
        return this.state;
    }

    public void setGameState(GameState state) {
        this.state = state;
    }

    public Tile createTile(Expansion expansion, String tileId, Vector<Element> tileElements, boolean isTunnelActive) {
        this.features = new java.util.HashMap<Location, Feature>();
        this.multiEdges = new ArrayList<Tuple3<ShortEdge, Location, FeaturePointer>>();
        this.tileId = tileId;
        this.logger.debug("Creating " + tileId);
        for (Element xml : tileElements) {
            int i;
            NodeList nl = xml.getElementsByTagName("cloister");
            for (i = 0; i < nl.getLength(); ++i) {
                this.processCloisterElement((Element)nl.item(i));
            }
            nl = xml.getElementsByTagName("road");
            for (i = 0; i < nl.getLength(); ++i) {
                this.processRoadElement((Element)nl.item(i), isTunnelActive);
            }
            nl = xml.getElementsByTagName("city");
            for (i = 0; i < nl.getLength(); ++i) {
                this.processCityElement((Element)nl.item(i));
            }
            nl = xml.getElementsByTagName("farm");
            for (i = 0; i < nl.getLength(); ++i) {
                this.processFarmElement((Element)nl.item(i));
            }
            nl = xml.getElementsByTagName("tower");
            for (i = 0; i < nl.getLength(); ++i) {
                this.processTowerElement((Element)nl.item(i));
            }
            nl = xml.getElementsByTagName("river");
            for (i = 0; i < nl.getLength(); ++i) {
                this.processRiverElement((Element)nl.item(i));
            }
        }
        for (Tuple3<ShortEdge, Location, FeaturePointer> multiEdge : this.multiEdges) {
            Map.Entry<Location, Feature> matched = null;
            for (Map.Entry<Location, Feature> entry : this.features.entrySet()) {
                if (!((Location)multiEdge._2).isPartOf(entry.getKey())) continue;
                matched = entry;
                break;
            }
            if (matched == null) {
                throw new IllegalArgumentException("Matching city not found");
            }
            City target = (City)matched.getValue();
            assert (target.getOpenEdges().contains(((ShortEdge)multiEdge._1).toEdge()));
            Set<Tuple2<ShortEdge, FeaturePointer>> targeMultiEdges = target.getMultiEdges();
            targeMultiEdges = targeMultiEdges.add(new Tuple2<ShortEdge, FeaturePointer>((ShortEdge)multiEdge._1, (FeaturePointer)multiEdge._3));
            target = target.setMultiEdges(targeMultiEdges);
            this.features.put(matched.getKey(), target);
        }
        HashMap<Location, Feature> _features = HashMap.ofAll(this.features);
        Tile tileDef = new Tile(expansion, tileId, _features);
        this.features = null;
        tileId = null;
        return tileDef;
    }

    public Feature initFeature(String tileId, Feature feature, Element xml) {
        if (feature instanceof Farm && tileId.startsWith("CO.")) {
            feature = ((Farm)feature).setAdjoiningCityOfCarcassonne(true);
        }
        for (Capability capability : this.state.getCapabilities().toSeq()) {
            feature = capability.initFeature(this.state, tileId, feature, xml);
        }
        return feature;
    }

    private void processCloisterElement(Element e) {
        Cloister cloister = new Cloister();
        cloister = (Cloister)this.initFeature(this.tileId, cloister, e);
        this.features.put(Location.CLOISTER, cloister);
    }

    private void processTowerElement(Element e) {
        Tower tower = new Tower();
        tower = (Tower)this.initFeature(this.tileId, tower, e);
        this.features.put(Location.TOWER, tower);
    }

    private void processRoadElement(Element e, boolean isTunnelActive) {
        Stream<Location> sides = XMLUtils.contentAsLocations(e);
        if (sides.size() > 1 && isTunnelActive && XMLUtils.attributeBoolValue(e, "tunnel")) {
            sides.forEach(loc -> this.processRoadElement(Stream.of(loc), e, true));
        } else {
            this.processRoadElement(sides, e, isTunnelActive);
        }
    }

    private void processRoadElement(Stream<Location> sides, Element e, boolean isTunnelActive) {
        FeaturePointer fp = this.initFeaturePointer(sides, Road.class);
        Road road = new Road(io.vavr.collection.List.of(fp), TileBuilder.initOpenEdges(sides));
        if (isTunnelActive && XMLUtils.attributeBoolValue(e, "tunnel")) {
            road = road.setOpenTunnelEnds(HashSet.of(fp));
        }
        road = (Road)this.initFeature(this.tileId, road, e);
        this.features.put(fp.getLocation(), road);
    }

    private void processCityElement(Element e) {
        Stream<Location> sides = XMLUtils.contentAsLocations(e);
        FeaturePointer place = this.initFeaturePointer(sides, City.class);
        Set<Edge> openEdges = TileBuilder.initOpenEdges(sides);
        if (e.hasAttribute("multi-edge")) {
            Location multiEdgeLoc = XMLUtils.attrAsLocation(e, "multi-edge");
            if (!multiEdgeLoc.isEdgeLocation()) {
                throw new IllegalArgumentException("Multi edge must be side location");
            }
            ShortEdge multiEdge = new ShortEdge(Position.ZERO, multiEdgeLoc);
            this.multiEdges.add(new Tuple3<ShortEdge, Location, FeaturePointer>(multiEdge, multiEdgeLoc, place));
            openEdges = openEdges.add(multiEdge);
        }
        City city = new City(io.vavr.collection.List.of(place), openEdges, XMLUtils.attributeIntValue(e, "pennant", 0), XMLUtils.attributeIntValue(e, "extra-points", 0));
        city = (City)this.initFeature(this.tileId, city, e);
        this.features.put(place.getLocation(), city);
    }

    private void processRiverElement(Element e) {
        Stream<Location> sides = XMLUtils.contentAsLocations(e);
        FeaturePointer place = this.initFeaturePointer(sides, River.class);
        River river = new River(io.vavr.collection.List.of(place));
        river = (River)this.initFeature(this.tileId, river, e);
        this.features.put(place.getLocation(), river);
    }

    private void processFarmElement(Element e) {
        HashSet<FeaturePointer> adjoiningCities;
        Stream<Location> sides = XMLUtils.contentAsLocations(e);
        FeaturePointer place = this.initFeaturePointer(sides, Farm.class);
        if (e.hasAttribute("city")) {
            LinearSeq<Location> citiesLocs = XMLUtils.attrAsLocations(e, "city");
            citiesLocs = citiesLocs.map(partial -> {
                for (Map.Entry<Location, Feature> entry : this.features.entrySet()) {
                    Location loc;
                    if (!(entry.getValue() instanceof City) || !partial.isPartOf(loc = entry.getKey())) continue;
                    return loc;
                }
                throw new IllegalArgumentException(String.format("Unable to match adjoining city %s for tile %s", partial, this.tileId));
            });
            adjoiningCities = HashSet.ofAll(citiesLocs.map(loc -> new FeaturePointer(Position.ZERO, (Location)loc)));
        } else {
            adjoiningCities = HashSet.empty();
        }
        Farm farm = new Farm(io.vavr.collection.List.of(place), adjoiningCities);
        farm = (Farm)this.initFeature(this.tileId, farm, e);
        this.features.put(place.getLocation(), farm);
    }

    private FeaturePointer initFeaturePointer(Stream<Location> sides, Class<? extends Feature> clazz) {
        AtomicReference locRef = new AtomicReference();
        sides.forEach(l -> {
            assert (clazz.equals(Farm.class) == l.isFarmLocation()) : String.format("Invalid location %s kind for tile %s", l, this.tileId);
            assert (l.intersect((Location)locRef.get()) == null);
            locRef.set(locRef.get() == null ? l : ((Location)locRef.get()).union((Location)l));
        });
        return new FeaturePointer(Position.ZERO, (Location)locRef.get());
    }

    public static Set<Edge> initOpenEdges(Stream<Location> sides) {
        return HashSet.ofAll(sides.filter(Location::isEdgeLocation).map(loc -> new Edge(Position.ZERO, (Location)loc)));
    }
}

