/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.board.pointer;

import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.pointer.BoardPointer;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.figure.Meeple;
import io.vavr.Tuple2;

public class MeeplePointer
implements BoardPointer {
    private static final long serialVersionUID = 1L;
    private final FeaturePointer featurePointer;
    private final String meepleId;

    public MeeplePointer(FeaturePointer featurePointer, String meepleId) {
        this.featurePointer = featurePointer;
        this.meepleId = meepleId;
    }

    public MeeplePointer(Position position, Location location, String meepleId) {
        this(new FeaturePointer(position, location), meepleId);
    }

    public MeeplePointer(Tuple2<? extends Meeple, FeaturePointer> t) {
        this((FeaturePointer)t._2, ((Meeple)t._1).getId());
    }

    @Override
    public FeaturePointer asFeaturePointer() {
        return this.featurePointer;
    }

    @Override
    public Position getPosition() {
        return this.featurePointer.getPosition();
    }

    public Location getLocation() {
        return this.featurePointer.getLocation();
    }

    public String getMeepleId() {
        return this.meepleId;
    }

    public boolean match(Meeple meeple) {
        if (meeple == null) {
            return false;
        }
        return this.meepleId.equals(meeple.getId());
    }

    public String toString() {
        return "[x=" + this.getPosition().x + ",y=" + this.getPosition().y + "," + this.getLocation() + "," + this.meepleId + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.featurePointer == null ? 0 : this.featurePointer.hashCode());
        result = 31 * result + (this.meepleId == null ? 0 : this.meepleId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MeeplePointer other = (MeeplePointer)obj;
        if (this.featurePointer == null ? other.featurePointer != null : !this.featurePointer.equals(other.featurePointer)) {
            return false;
        }
        return !(this.meepleId == null ? other.meepleId != null : !this.meepleId.equals(other.meepleId));
    }
}

