/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.feature;

import com.jcloisterzone.Player;
import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.Rotation;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.feature.CloisterLike;
import com.jcloisterzone.feature.Feature;
import com.jcloisterzone.feature.Scoreable;
import com.jcloisterzone.feature.TileFeature;
import com.jcloisterzone.figure.Follower;
import com.jcloisterzone.figure.Meeple;
import com.jcloisterzone.game.capability.VineyardCapability;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.game.state.PlacedTile;
import com.jcloisterzone.ui.I18nUtils;
import io.vavr.Tuple2;
import io.vavr.collection.HashMap;
import io.vavr.collection.HashSet;
import io.vavr.collection.List;
import io.vavr.collection.Set;
import io.vavr.collection.Stream;

public class Cloister
extends TileFeature
implements Scoreable,
CloisterLike {
    private static final long serialVersionUID = 1L;
    private static final List<FeaturePointer> INITIAL_PLACE = List.of(new FeaturePointer(Position.ZERO, Location.CLOISTER));
    protected final Set<FeaturePointer> neighboring;
    protected final boolean shrine;
    protected final boolean monastery;
    protected final boolean church;

    public Cloister() {
        this(INITIAL_PLACE, HashSet.empty(), false, false, false);
    }

    public Cloister(List<FeaturePointer> places, Set<FeaturePointer> neighboring, boolean shrine, boolean monastery, boolean church) {
        super(places);
        this.neighboring = neighboring;
        this.shrine = shrine;
        this.monastery = monastery;
        this.church = church;
    }

    @Override
    public Cloister setNeighboring(Set<FeaturePointer> neighboring) {
        if (this.neighboring == neighboring) {
            return this;
        }
        return new Cloister(this.places, neighboring, this.shrine, this.monastery, this.church);
    }

    @Override
    public Set<FeaturePointer> getNeighboring() {
        return this.neighboring;
    }

    @Override
    public Feature placeOnBoard(Position pos, Rotation rot) {
        return new Cloister(this.placeOnBoardPlaces(pos, rot), this.placeOnBoardNeighboring(pos, rot), this.shrine, this.monastery, this.church);
    }

    public boolean isShrine() {
        return this.shrine;
    }

    public Cloister setShrine(boolean shrine) {
        if (this.shrine == shrine) {
            return this;
        }
        return new Cloister(this.places, this.neighboring, shrine, this.monastery, this.church);
    }

    public boolean isMonastery() {
        return this.monastery;
    }

    public Cloister setMonastery(boolean monastery) {
        if (this.monastery == monastery) {
            return this;
        }
        return new Cloister(this.places, this.neighboring, this.shrine, monastery, this.church);
    }

    public boolean isChurch() {
        return this.church;
    }

    public Cloister setChurch(boolean church) {
        if (this.church == church) {
            return this;
        }
        return new Cloister(this.places, this.neighboring, this.shrine, this.monastery, church);
    }

    public Stream<Tuple2<Meeple, FeaturePointer>> getMeeplesIncludingMonastery2(GameState state) {
        if (this.isMonastery()) {
            FeaturePointer place = (FeaturePointer)this.places.get();
            HashSet<FeaturePointer> fps = HashSet.of(place, new FeaturePointer(place.getPosition(), Location.MONASTERY));
            return Stream.ofAll(state.getDeployedMeeples()).filter(t -> fps.contains((FeaturePointer)t._2));
        }
        return this.getMeeples2(state);
    }

    public Stream<Meeple> getMeeplesIncludingMonastery(GameState state) {
        if (this.isMonastery()) {
            return this.getMeeplesIncludingMonastery2(state).map(Tuple2::_1);
        }
        return this.getMeeples(state);
    }

    public Stream<Tuple2<Follower, FeaturePointer>> getMonasteryFollowers2(GameState state) {
        FeaturePointer place = this.getPlace().setLocation(Location.MONASTERY);
        return Stream.ofAll(state.getDeployedMeeples()).filter(t -> t._1 instanceof Follower && ((FeaturePointer)t._2).equals(place)).map(t -> t.map1(f -> (Follower)f));
    }

    public HashMap<Player, Integer> getMonasteryPowers(GameState state) {
        return this.getMonasteryFollowers2(state).foldLeft(HashMap.empty(), (acc, follower2) -> {
            Follower follower = (Follower)follower2._1;
            FeaturePointer fp = (FeaturePointer)follower2._2;
            Player player = follower.getPlayer();
            int power = follower.getPower(state, this);
            Integer p = acc.get(player).getOrElse(0);
            return acc.put(player, (Object)(p + power));
        });
    }

    public Set<Player> getMonasteryOwners(GameState state) {
        HashMap<Player, Integer> powers = this.getMonasteryPowers(state);
        int maxPower = powers.values().max().getOrElse(0);
        if (maxPower == 0) {
            return HashSet.empty();
        }
        return ((HashMap)powers.filterValues(p -> p == maxPower)).keySet();
    }

    public Follower getMonasterySampleFollower(GameState state, Player player) {
        return (Follower)this.getMonasteryFollowers2(state).map(Tuple2::_1).find(f -> f.getPlayer().equals(player)).getOrNull();
    }

    @Override
    public int getPoints(GameState state) {
        boolean scoreVineyards = state.hasCapability(VineyardCapability.class);
        Position p = ((FeaturePointer)this.places.get()).getPosition();
        int adjacent = 0;
        int adjacentVineyards = 0;
        for (Tuple2 tuple2 : state.getAdjacentAndDiagonalTiles2(p)) {
            ++adjacent;
            if (!scoreVineyards || !((PlacedTile)tuple2._2).getTile().hasModifier(VineyardCapability.VINEYARD)) continue;
            ++adjacentVineyards;
        }
        int vineyardPoints = adjacent == 8 ? adjacentVineyards * 3 : 0;
        return adjacent + 1 + vineyardPoints + this.getLittleBuildingPoints(state);
    }

    public static String name() {
        return I18nUtils._tr("Cloister", new Object[0]);
    }

    protected Set<FeaturePointer> placeOnBoardNeighboring(Position pos, Rotation rot) {
        return this.neighboring.map(fp -> fp.rotateCW(rot).translate(pos));
    }
}

