/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.feature;

import com.jcloisterzone.PointCategory;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.feature.Completable;
import com.jcloisterzone.game.capability.LittleBuildingsCapability;
import com.jcloisterzone.game.state.GameState;
import io.vavr.collection.HashSet;
import io.vavr.collection.Map;
import io.vavr.collection.Seq;
import io.vavr.collection.Set;

public interface CloisterLike
extends Completable {
    @Override
    default public boolean isOpen(GameState state) {
        return state.getAdjacentAndDiagonalTiles2(this.getPosition()).size() < 8;
    }

    default public Position getPosition() {
        return ((FeaturePointer)this.getPlaces().get()).getPosition();
    }

    @Override
    default public Set<Position> getTilePositions() {
        return HashSet.of(this.getPosition());
    }

    @Override
    default public PointCategory getPointCategory() {
        return PointCategory.CLOISTER;
    }

    @Override
    default public int getStructurePoints(GameState state, boolean completed) {
        return this.getPoints(state);
    }

    @Override
    default public int getLittleBuildingPoints(GameState state) {
        Map buildings = (Map)state.getCapabilityModel(LittleBuildingsCapability.class);
        if (buildings == null) {
            return 0;
        }
        Position cloisterPos = this.getPosition();
        Seq<LittleBuildingsCapability.LittleBuilding> buldingsSeq = buildings.filterKeys(pos -> Math.abs(pos.x - cloisterPos.x) <= 1 && Math.abs(pos.y - cloisterPos.y) <= 1).values();
        return LittleBuildingsCapability.getBuildingsPoints(state, buldingsSeq);
    }
}

