/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.feature;

import com.jcloisterzone.Player;
import com.jcloisterzone.PointCategory;
import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.Rotation;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.feature.Castle;
import com.jcloisterzone.feature.City;
import com.jcloisterzone.feature.Feature;
import com.jcloisterzone.feature.MultiTileFeature;
import com.jcloisterzone.feature.Scoreable;
import com.jcloisterzone.feature.TileFeature;
import com.jcloisterzone.figure.Pig;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.ui.I18nUtils;
import io.vavr.collection.List;
import io.vavr.collection.Set;
import io.vavr.collection.Traversable;

public class Farm
extends TileFeature
implements Scoreable,
MultiTileFeature<Farm> {
    protected final Set<FeaturePointer> adjoiningCities;
    protected final boolean adjoiningCityOfCarcassonne;
    protected final int pigHerds;

    public Farm(List<FeaturePointer> places, Set<FeaturePointer> adjoiningCities) {
        this(places, adjoiningCities, false, 0);
    }

    public Farm(List<FeaturePointer> places, Set<FeaturePointer> adjoiningCities, boolean adjoiningCityOfCarcassonne, int pigHerds) {
        super(places);
        this.adjoiningCities = adjoiningCities;
        this.adjoiningCityOfCarcassonne = adjoiningCityOfCarcassonne;
        this.pigHerds = pigHerds;
    }

    @Override
    public Farm merge(Farm farm) {
        assert (farm != this);
        return new Farm(this.mergePlaces(farm), this.mergeAdjoiningCities(farm), this.adjoiningCityOfCarcassonne || farm.adjoiningCityOfCarcassonne, this.pigHerds + farm.pigHerds);
    }

    @Override
    public Feature placeOnBoard(Position pos, Rotation rot) {
        return new Farm(this.placeOnBoardPlaces(pos, rot), this.placeOnBoardAdjoiningCities(pos, rot), this.adjoiningCityOfCarcassonne, this.pigHerds);
    }

    public boolean isOpen(GameState state) {
        Location loc;
        List<FeaturePointer> places = this.getPlaces();
        if (places.length() == 1 && ((loc = ((FeaturePointer)places.get()).getLocation()) == Location.INNER_FARM || loc == Location.INNER_FARM_B)) {
            return false;
        }
        for (FeaturePointer fp : places) {
            Position pos = fp.getPosition();
            for (Location loc2 : fp.getLocation().splitToFarmSides().map(Location::farmToSide).distinct()) {
                if (state.getPlacedTiles().containsKey(pos.add(loc2))) continue;
                return true;
            }
        }
        return false;
    }

    public Set<FeaturePointer> getAdjoiningCities() {
        return this.adjoiningCities;
    }

    public Farm setAdjoiningCities(Set<FeaturePointer> adjoiningCities) {
        return new Farm(this.places, adjoiningCities, this.adjoiningCityOfCarcassonne, this.pigHerds);
    }

    public int getPigHerds() {
        return this.pigHerds;
    }

    public Farm setPigHerds(int pigHerds) {
        return new Farm(this.places, this.adjoiningCities, this.adjoiningCityOfCarcassonne, pigHerds);
    }

    public boolean isAdjoiningCityOfCarcassonne() {
        return this.adjoiningCityOfCarcassonne;
    }

    public Farm setAdjoiningCityOfCarcassonne(boolean adjoiningCityOfCarcassonne) {
        return new Farm(this.places, this.adjoiningCities, adjoiningCityOfCarcassonne, this.pigHerds);
    }

    @Override
    public PointCategory getPointCategory() {
        return PointCategory.FARM;
    }

    private int getPointsPerCity(GameState state, Player player, int basePoints) {
        return basePoints + this.pigHerds + this.getSpecialMeeples(state).count(m -> m instanceof Pig && m.getPlayer().equals(player));
    }

    public int getPoints(GameState state, Player player) {
        return this.getCityPoints(state, this.getPointsPerCity(state, player, 3)) + this.getLittleBuildingPoints(state);
    }

    public int getPointsWhenBarnIsConnected(GameState state, Player player) {
        return this.getCityPoints(state, this.getPointsPerCity(state, player, 1)) + this.getLittleBuildingPoints(state);
    }

    public int getBarnPoints(GameState state) {
        return this.getCityPoints(state, 4) + this.getLittleBuildingPoints(state);
    }

    private int getCityPoints(GameState state, int pointsPerCity) {
        int points = this.adjoiningCityOfCarcassonne ? pointsPerCity : 0;
        Traversable features = this.adjoiningCities.map(fp -> state.getFeature((FeaturePointer)fp));
        for (Feature feature : features) {
            if (feature instanceof Castle) {
                points += pointsPerCity + 1;
                continue;
            }
            City city = (City)feature;
            if (!city.isCompleted(state)) continue;
            points += pointsPerCity;
            if (!city.isBesieged()) continue;
            points += pointsPerCity;
        }
        return points;
    }

    public static String name() {
        return I18nUtils._tr("Farm", new Object[0]);
    }

    protected Set<FeaturePointer> mergeAdjoiningCities(Farm obj) {
        return this.adjoiningCities.union(obj.adjoiningCities);
    }

    protected Set<FeaturePointer> placeOnBoardAdjoiningCities(Position pos, Rotation rot) {
        return this.adjoiningCities.map(fp -> fp.rotateCW(rot).translate(pos));
    }
}

