/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.feature;

import com.jcloisterzone.Player;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.feature.Feature;
import com.jcloisterzone.figure.Follower;
import com.jcloisterzone.figure.Meeple;
import com.jcloisterzone.figure.Special;
import com.jcloisterzone.game.state.GameState;
import io.vavr.Tuple2;
import io.vavr.collection.HashSet;
import io.vavr.collection.Stream;

public interface Structure
extends Feature {
    default public Stream<Tuple2<Meeple, FeaturePointer>> getMeeples2(GameState state) {
        HashSet<FeaturePointer> fps = HashSet.ofAll(this.getPlaces());
        return Stream.ofAll(state.getDeployedMeeples()).filter(t -> fps.contains((FeaturePointer)t._2));
    }

    default public Stream<Meeple> getMeeples(GameState state) {
        return this.getMeeples2(state).map(t -> (Meeple)t._1);
    }

    default public Stream<Tuple2<Follower, FeaturePointer>> getFollowers2(GameState state) {
        return this.getMeeples2(state).filter(t -> t._1 instanceof Follower).map(t -> t.map1(f -> (Follower)f));
    }

    default public Stream<Follower> getFollowers(GameState state) {
        return this.getFollowers2(state).map(t -> (Follower)t._1);
    }

    default public Stream<Tuple2<Special, FeaturePointer>> getSpecialMeeples2(GameState state) {
        return this.getMeeples2(state).filter(t -> t._1 instanceof Special).map(t -> t.map1(m -> (Special)m));
    }

    default public Stream<Special> getSpecialMeeples(GameState state) {
        return this.getSpecialMeeples2(state).map(t -> (Special)t._1);
    }

    default public boolean isOccupied(GameState state) {
        return !this.getMeeples(state).isEmpty();
    }

    default public boolean isOccupiedBy(GameState state, Player p) {
        return !this.getFollowers(state).find(m -> m.getPlayer().equals(p)).isEmpty();
    }
}

