/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.feature;

import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.Rotation;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.feature.Feature;
import io.vavr.collection.List;
import java.io.Serializable;

public abstract class TileFeature
implements Feature,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final List<FeaturePointer> places;

    public TileFeature(List<FeaturePointer> places) {
        this.places = places;
    }

    @Override
    public List<FeaturePointer> getPlaces() {
        return this.places;
    }

    public FeaturePointer getPlace() {
        return (FeaturePointer)this.places.get();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    protected List<FeaturePointer> mergePlaces(TileFeature obj) {
        return this.places.appendAll(obj.places);
    }

    protected List<FeaturePointer> placeOnBoardPlaces(Position pos, Rotation rot) {
        return this.places.map(fp -> fp.rotateCW(rot).translate(pos));
    }
}

