/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.figure;

import com.jcloisterzone.Player;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.board.pointer.MeeplePointer;
import com.jcloisterzone.feature.Structure;
import com.jcloisterzone.figure.DeploymentCheckResult;
import com.jcloisterzone.figure.Figure;
import com.jcloisterzone.game.state.GameState;
import io.vavr.Predicates;

public abstract class Meeple
extends Figure<FeaturePointer> {
    private static final long serialVersionUID = 251811435063355665L;
    private final transient Player player;

    public Meeple(String id, Player player) {
        super(id);
        this.player = player;
    }

    @Override
    public FeaturePointer getDeployment(GameState state) {
        return (FeaturePointer)state.getDeployedMeeples().get(this).getOrNull();
    }

    @Override
    public boolean at(GameState state, Structure feature) {
        return feature.getMeeples(state).find(Predicates.is(this)).isDefined();
    }

    public boolean at(GameState state, MeeplePointer mp) {
        if (!this.at(state, mp.asFeaturePointer())) {
            return false;
        }
        return mp.getMeepleId().equals(this.getId());
    }

    public boolean canBeEatenByDragon(GameState state) {
        return true;
    }

    public DeploymentCheckResult isDeploymentAllowed(GameState state, FeaturePointer fp, Structure feature) {
        return DeploymentCheckResult.OK;
    }

    public Player getPlayer() {
        return this.player;
    }
}

