/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game;

import com.google.common.eventbus.EventBus;
import com.jcloisterzone.EventBusExceptionHandler;
import com.jcloisterzone.EventProxy;
import com.jcloisterzone.Expansion;
import com.jcloisterzone.Player;
import com.jcloisterzone.PlayerClock;
import com.jcloisterzone.action.PlayerAction;
import com.jcloisterzone.ai.AiPlayer;
import com.jcloisterzone.ai.AiPlayerAdapter;
import com.jcloisterzone.ai.ForceSupportIfSupports;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.board.pointer.MeeplePointer;
import com.jcloisterzone.config.Config;
import com.jcloisterzone.event.ClockUpdateEvent;
import com.jcloisterzone.event.Event;
import com.jcloisterzone.event.GameChangedEvent;
import com.jcloisterzone.event.GameOverEvent;
import com.jcloisterzone.event.play.PlayEvent;
import com.jcloisterzone.event.setup.SupportedExpansionsChangeEvent;
import com.jcloisterzone.figure.Meeple;
import com.jcloisterzone.game.Capability;
import com.jcloisterzone.game.GameSetup;
import com.jcloisterzone.game.GameStatePhaseReducer;
import com.jcloisterzone.game.MessageNotHandledException;
import com.jcloisterzone.game.PlayerSlot;
import com.jcloisterzone.game.SupportedSetup;
import com.jcloisterzone.game.UndoHistoryItem;
import com.jcloisterzone.game.phase.GameOverPhase;
import com.jcloisterzone.game.phase.Phase;
import com.jcloisterzone.game.state.ActionsState;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.game.state.GameStateBuilder;
import com.jcloisterzone.ui.GameController;
import com.jcloisterzone.wsio.Connection;
import com.jcloisterzone.wsio.WsSubscribe;
import com.jcloisterzone.wsio.message.GameOverMessage;
import com.jcloisterzone.wsio.message.SlotMessage;
import com.jcloisterzone.wsio.message.WsReplayableMessage;
import com.jcloisterzone.wsio.message.WsSaltMessage;
import io.vavr.Tuple2;
import io.vavr.collection.Array;
import io.vavr.collection.LinkedHashMap;
import io.vavr.collection.List;
import io.vavr.collection.Queue;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Game
implements EventProxy {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private Connection connection;
    private final String gameId;
    private String name;
    private long initialSeed;
    private GameSetup setup;
    private GameState state;
    private long clockStart;
    private Array<PlayerClock> clocks;
    private GameStatePhaseReducer phaseReducer;
    private List<WsReplayableMessage> replay;
    private HashMap<String, Object> gameAnnotations;
    protected PlayerSlot[] slots;
    protected SupportedSetup[] slotSupported = new SupportedSetup[6];
    private boolean aiPlayersRegistered;
    private List<UndoHistoryItem> undoHistory = List.empty();
    private final EventBus eventBus = new EventBus(new EventBusExceptionHandler("game event bus"));
    boolean corrupted;

    public Game(String gameId, long randomSeed) {
        this.gameId = gameId;
        this.initialSeed = randomSeed;
    }

    public String getGameId() {
        return this.gameId;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getInitialSeed() {
        return this.initialSeed;
    }

    public GameState getState() {
        return this.state;
    }

    public void setSetup(GameSetup setup) {
        this.setup = setup;
    }

    public GameSetup getSetup() {
        return this.setup;
    }

    public Array<PlayerClock> getClocks() {
        return this.clocks;
    }

    public void mapSetup(Function<GameSetup, GameSetup> mapper) {
        this.setSetup(mapper.apply(this.setup));
    }

    public List<WsReplayableMessage> getReplay() {
        return this.replay;
    }

    public void replaceState(GameState state) {
        if (this.state == state) {
            return;
        }
        GameState prev = this.state;
        this.state = state;
        boolean gameIsOver = this.isOver();
        if (gameIsOver && state.getTurnPlayer().getSlot().isOwn()) {
            this.connection.send(new GameOverMessage());
        }
        GameChangedEvent ev = new GameChangedEvent(prev, state);
        this.post(ev);
        if (gameIsOver) {
            this.post(new GameOverEvent());
        }
        if (this.logger.isDebugEnabled()) {
            ActionsState as;
            StringBuilder sb;
            Queue<PlayEvent> playEvents = ev.getNewPlayEvents();
            if (!playEvents.isEmpty()) {
                sb = new StringBuilder();
                sb.append("play events:");
                for (PlayEvent pev : ev.getNewPlayEvents()) {
                    sb.append("\n  - ");
                    sb.append(pev.toString());
                }
                this.logger.debug(sb.toString());
            }
            if ((as = state.getPlayerActions()) != null) {
                sb = new StringBuilder();
                sb.append(as.getPlayer().getNick());
                sb.append("'s actions:");
                for (PlayerAction playerAction : as.getActions()) {
                    sb.append("\n  - ");
                    sb.append(playerAction.toString());
                    if (playerAction.getOptions() == null) continue;
                    sb.append("\n    ");
                    sb.append(String.join((CharSequence)", ", playerAction.getOptions().map(Object::toString)));
                }
                this.logger.debug(sb.toString());
            }
        }
    }

    @Override
    public EventBus getEventBus() {
        return this.eventBus;
    }

    private void markUndo() {
        this.undoHistory = this.undoHistory.prepend((Object)new UndoHistoryItem(this.state, this.replay));
    }

    private void clearUndo() {
        this.undoHistory = List.empty();
    }

    public List<UndoHistoryItem> getUndoHistory() {
        return this.undoHistory;
    }

    public boolean isUndoAllowed() {
        return !this.undoHistory.isEmpty();
    }

    public void undo() {
        if (this.undoHistory.isEmpty()) {
            throw new IllegalStateException();
        }
        Tuple2<UndoHistoryItem, List<UndoHistoryItem>> head = this.undoHistory.pop2();
        this.undoHistory = (List)head._2;
        this.replay = ((UndoHistoryItem)head._1).getReplay();
        this.replaceState(((UndoHistoryItem)head._1).getState());
    }

    public String getMessageId() {
        return this.getMessageId(this.state);
    }

    private String getMessageId(GameState state) {
        return String.format("%s.%s", state.getTurnNumber());
    }

    @WsSubscribe
    public void handleSlotMessage(SlotMessage msg) {
        this.slotSupported[msg.getNumber()] = msg.getSupportedSetup();
        this.post(new SupportedExpansionsChangeEvent(this.mergeSupportedExpansions()));
    }

    @WsSubscribe
    public void handleInGameMessage(WsReplayableMessage msg) {
        boolean undoAllowed;
        WsReplayableMessage prevMsg;
        if (!this.replay.isEmpty() && (prevMsg = (WsReplayableMessage)this.replay.get()).getMessageId().equals(msg.getMessageId())) {
            this.logger.warn("Dropping already delivered message {}", (Object)msg.getMessageId());
            return;
        }
        long origSalt = this.phaseReducer.getRandom().getSalt();
        GameState newState = null;
        try {
            if (msg instanceof WsSaltMessage) {
                this.phaseReducer.getRandom().setSalt(((WsSaltMessage)((Object)msg)).getSalt());
            }
            newState = this.phaseReducer.apply(this.state, msg);
        }
        catch (Exception e) {
            this.phaseReducer.getRandom().setSalt(origSalt);
            throw e;
        }
        Player oldActivePlayer = this.state.getActivePlayer();
        Player newActivePlayer = newState.getActivePlayer();
        boolean bl = undoAllowed = !(msg instanceof WsSaltMessage) && newActivePlayer != null && newActivePlayer.equals(oldActivePlayer);
        if (undoAllowed) {
            this.markUndo();
        } else {
            this.clearUndo();
        }
        this.replay = this.replay.prepend((Object)msg);
        Player player = newState.getActivePlayer();
        if (this.state.getActivePlayer() != player) {
            this.updateClocks(player == null ? -1 : player.getIndex(), msg.getClock());
        }
        this.replaceState(newState);
    }

    public void updateClocks(int runIndex, long clock) {
        for (int i = 0; i < this.clocks.size(); ++i) {
            PlayerClock pc = this.clocks.get(i);
            if (pc.isRunning()) {
                if (runIndex == i) continue;
                this.clocks = this.clocks.update(i, (Object)pc.stop(clock));
                continue;
            }
            if (runIndex != i) continue;
            this.clocks = this.clocks.update(i, (Object)pc.start(clock));
        }
        this.post(new ClockUpdateEvent(this.clocks, runIndex));
    }

    public Set<Expansion> mergeSupportedExpansions() {
        SupportedSetup merged = SupportedSetup.getCurrentClientSupported();
        for (int i = 0; i < this.slotSupported.length; ++i) {
            if (this.slotSupported[i] == null) continue;
            merged = merged.intersect(this.slotSupported[i]);
        }
        HashSet<Expansion> supportedExpansions = new HashSet<Expansion>();
        block1: for (Expansion exp : Expansion.values()) {
            if (!merged.getTiles().contains(exp)) continue;
            for (Class<Capability<?>> clazz : exp.getCapabilities()) {
                ForceSupportIfSupports forced;
                if (!merged.getCapabilities().contains(clazz) && ((forced = clazz.getAnnotation(ForceSupportIfSupports.class)) == null || !merged.getCapabilities().contains(forced.value()))) continue block1;
            }
            supportedExpansions.add(exp);
        }
        return supportedExpansions;
    }

    @Override
    public void post(Event event) {
        this.eventBus.post(event);
    }

    public void start(GameController gc, List<WsReplayableMessage> replay, HashMap<String, Object> savedGameAnnotations) {
        GameState state;
        this.replay = replay.reverse();
        this.phaseReducer = new GameStatePhaseReducer(this.setup, this.initialSeed);
        GameStateBuilder builder = new GameStateBuilder(this.setup, this.slots, gc.getConfig());
        if (savedGameAnnotations != null) {
            this.gameAnnotations = savedGameAnnotations;
        } else {
            Config.DebugConfig debugConfig = gc.getConfig().getDebug();
            if (debugConfig != null) {
                this.gameAnnotations = debugConfig.getGame_annotation();
            }
        }
        builder.setGameAnnotations(this.gameAnnotations);
        this.state = state = builder.createInitialState();
        this.clocks = state.getPlayers().getPlayers().map(p -> new PlayerClock(0L));
        this.createAiPlayers(gc);
        gc.onGameStarted(this);
        Phase firstPhase = this.phaseReducer.getFirstPhase();
        state = builder.createReadyState(state);
        state = state.setPhase(firstPhase.getClass());
        state = this.phaseReducer.applyStepResult(firstPhase.enter(state));
        for (WsReplayableMessage msg : replay) {
            try {
                if (msg instanceof WsSaltMessage) {
                    this.phaseReducer.getRandom().setSalt(((WsSaltMessage)((Object)msg)).getSalt());
                }
                GameState prev = state;
                state = this.phaseReducer.apply(state, msg);
            }
            catch (MessageNotHandledException ex) {
                this.corrupted = true;
            }
        }
        this.updateClocks(state.getActivePlayer().getIndex(), 0L);
        this.replaceState(state);
        if (this.corrupted) {
            this.logger.error("Game is inconsistent. Loaded anyway ignoring invalid messages.");
        }
    }

    private void createAiPlayers(GameController gc) {
        if (this.aiPlayersRegistered) {
            return;
        }
        block2: for (PlayerSlot slot : this.slots) {
            if (slot == null || !slot.isAi() || !slot.isOwn()) continue;
            try {
                AiPlayer ai = (AiPlayer)Class.forName(slot.getAiClassName()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                for (Player player : this.state.getPlayers().getPlayers()) {
                    if (player.getSlot().getNumber() != slot.getNumber()) continue;
                    AiPlayerAdapter adapter = new AiPlayerAdapter(gc, player, ai);
                    this.eventBus.register(adapter);
                    this.logger.info("AI player created - " + slot.getAiClassName());
                    continue block2;
                }
            }
            catch (Exception e) {
                this.logger.error("Unable to create AI player", e);
            }
        }
        this.aiPlayersRegistered = true;
    }

    public void setSlots(PlayerSlot[] slots) {
        this.slots = slots;
    }

    public PlayerSlot[] getPlayerSlots() {
        return this.slots;
    }

    public Phase getPhase() {
        if (this.state == null) {
            return null;
        }
        return this.phaseReducer.getPhase(this.state.getPhase());
    }

    public LinkedHashMap<Meeple, FeaturePointer> getDeployedMeeples() {
        return this.state.getDeployedMeeples();
    }

    public Meeple getMeeple(MeeplePointer mp) {
        Tuple2 match = (Tuple2)this.getDeployedMeeples().find(t -> mp.match((Meeple)t._1)).getOrNull();
        return match == null ? null : (Meeple)match._1;
    }

    public boolean isStarted() {
        return this.state != null;
    }

    public boolean isOver() {
        return this.getPhase() instanceof GameOverPhase;
    }

    public HashMap<String, Object> getGameAnnotations() {
        return this.gameAnnotations;
    }

    public long getClockStart() {
        return this.clockStart;
    }

    public void setClockStart(long clockStart) {
        this.clockStart = clockStart;
    }

    public boolean isCorrupted() {
        return this.corrupted;
    }
}

