/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game;

import com.jcloisterzone.Expansion;
import com.jcloisterzone.game.Capability;
import com.jcloisterzone.game.Rule;
import com.jcloisterzone.game.capability.PigHerdCapability;
import com.jcloisterzone.game.state.mixins.RulesMixin;
import io.vavr.collection.Map;
import io.vavr.collection.Set;
import io.vavr.collection.Stream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.function.Function;

public class GameSetup
implements Serializable,
RulesMixin {
    private static final long serialVersionUID = 1L;
    private final Map<Expansion, Integer> expansions;
    private final Map<Rule, Object> rules;
    private final Set<Class<? extends Capability<?>>> capabilities;

    public GameSetup(Map<Expansion, Integer> expansions, Set<Class<? extends Capability<?>>> capabilities, Map<Rule, Object> rules) {
        this.expansions = expansions;
        this.capabilities = capabilities;
        this.rules = rules;
    }

    public boolean hasExpansion(Expansion expansion) {
        return this.expansions.containsKey(expansion);
    }

    public Map<Expansion, Integer> getExpansions() {
        return this.expansions;
    }

    public GameSetup setExpansions(Map<Expansion, Integer> expansions) {
        if (this.expansions == expansions) {
            return this;
        }
        return new GameSetup(expansions, this.capabilities, this.rules);
    }

    public GameSetup mapExpansions(Function<Map<Expansion, Integer>, Map<Expansion, Integer>> mapper) {
        return this.setExpansions(mapper.apply(this.expansions));
    }

    @Override
    public Map<Rule, Object> getRules() {
        return this.rules;
    }

    public GameSetup setRules(Map<Rule, Object> rules) {
        if (this.rules == rules) {
            return this;
        }
        return new GameSetup(this.expansions, this.capabilities, rules);
    }

    public GameSetup mapRules(Function<Map<Rule, Object>, Map<Rule, Object>> mapper) {
        return this.setRules(mapper.apply(this.rules));
    }

    public Set<Class<? extends Capability<?>>> getCapabilities() {
        return this.capabilities;
    }

    public GameSetup setCapabilities(Set<Class<? extends Capability<?>>> capabilities) {
        if (this.capabilities == capabilities) {
            return this;
        }
        return new GameSetup(this.expansions, capabilities, this.rules);
    }

    public GameSetup mapCapabilities(Function<Set<Class<? extends Capability<?>>>, Set<Class<? extends Capability<?>>>> mapper) {
        return this.setCapabilities(mapper.apply(this.capabilities));
    }

    public static Set<Class<? extends Capability<?>>> getCapabilitiesForExpansionsAndRules(Map<Expansion, Integer> expansions, Map<Rule, Object> rules) {
        Set<Class<Capability<Object>>> capabilities = Stream.ofAll(expansions.keySet()).flatMap(exp -> Arrays.asList(exp.getCapabilities())).toSet();
        if (((Boolean)rules.get(Rule.USE_PIG_HERDS_INDEPENDENTLY).getOrElse(Boolean.FALSE)).booleanValue()) {
            capabilities = capabilities.add(PigHerdCapability.class);
        }
        return capabilities;
    }
}

