/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game;

import com.google.gson.annotations.JsonAdapter;
import com.jcloisterzone.Expansion;
import com.jcloisterzone.game.Capability;
import com.jcloisterzone.wsio.message.adapters.CapabilitiesSetAdapter;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class SupportedSetup
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonAdapter(value=CapabilitiesSetAdapter.class)
    private Set<Class<? extends Capability<?>>> capabilities;
    private Set<Expansion> tiles;

    public static SupportedSetup getCurrentClientSupported() {
        HashSet capabilities = new HashSet();
        Set<Expansion> tiles = Expansion.values().toJavaSet();
        for (Expansion exp : tiles) {
            for (Class<? extends Capability<?>> cap : exp.getCapabilities()) {
                capabilities.add(cap);
            }
        }
        return new SupportedSetup(capabilities, tiles);
    }

    public SupportedSetup(Set<Class<? extends Capability<?>>> capabilities, Set<Expansion> tiles) {
        this.capabilities = capabilities;
        this.tiles = tiles;
    }

    public Set<Class<? extends Capability<?>>> getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(Set<Class<? extends Capability<?>>> capabilities) {
        this.capabilities = capabilities;
    }

    public Set<Expansion> getTiles() {
        return this.tiles;
    }

    public void setTiles(Set<Expansion> tiles) {
        this.tiles = tiles;
    }

    public SupportedSetup intersect(SupportedSetup other) {
        HashSet capabilities = new HashSet(this.capabilities);
        capabilities.retainAll(other.capabilities);
        HashSet<Expansion> tiles = new HashSet<Expansion>(this.tiles);
        tiles.retainAll(other.tiles);
        return new SupportedSetup(capabilities, tiles);
    }
}

