/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game.capability;

import com.jcloisterzone.Player;
import com.jcloisterzone.action.BridgeAction;
import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.event.play.TokenPlacedEvent;
import com.jcloisterzone.game.Capability;
import com.jcloisterzone.game.Token;
import com.jcloisterzone.game.state.GameState;
import io.vavr.collection.HashSet;
import io.vavr.collection.Set;

public class BridgeCapability
extends Capability<Set<FeaturePointer>> {
    private static final long serialVersionUID = 1L;

    @Override
    public GameState onStartGame(GameState state) {
        int tokens = state.getPlayers().length() < 5 ? 3 : 2;
        state = state.mapPlayers(ps -> ps.setTokenCountForAllPlayers(BrigeToken.BRIDGE, tokens));
        state = this.setModel(state, HashSet.empty());
        return state;
    }

    @Override
    public GameState onActionPhaseEntered(GameState state) {
        boolean playerHasBridge;
        Player player = state.getPlayerActions().getPlayer();
        boolean bl = playerHasBridge = state.getPlayers().getPlayerTokenCount(player.getIndex(), BrigeToken.BRIDGE) > 0;
        if (!playerHasBridge || state.getCurrentTurnPartEvents().find(ev -> ev instanceof TokenPlacedEvent && ((TokenPlacedEvent)ev).getToken() == BrigeToken.BRIDGE).isDefined()) {
            return state;
        }
        Position pos = state.getLastPlaced().getPosition();
        Set<FeaturePointer> options = HashSet.empty();
        for (Location bridgeLoc : Location.BRIDGES) {
            FeaturePointer ptr = new FeaturePointer(pos, bridgeLoc);
            if (!state.isBridgePlacementAllowed(ptr)) continue;
            options = options.add(ptr);
        }
        if (options.isEmpty()) {
            return state;
        }
        return state.appendAction(new BridgeAction(options));
    }

    public static enum BrigeToken implements Token
    {
        BRIDGE;

    }
}

