/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game.capability;

import com.jcloisterzone.Player;
import com.jcloisterzone.figure.Builder;
import com.jcloisterzone.figure.MeepleIdProvider;
import com.jcloisterzone.figure.Special;
import com.jcloisterzone.game.Capability;
import com.jcloisterzone.game.capability.BuilderState;
import com.jcloisterzone.game.state.GameState;
import io.vavr.collection.List;

public class BuilderCapability
extends Capability<BuilderState> {
    private static final long serialVersionUID = 1L;

    @Override
    public GameState onStartGame(GameState state) {
        return this.setModel(state, BuilderState.UNUSED);
    }

    public GameState useBuilder(GameState state) {
        return this.updateModel(state, builderState -> builderState == BuilderState.UNUSED ? BuilderState.USED : builderState);
    }

    @Override
    public List<Special> createPlayerSpecialMeeples(Player p, MeepleIdProvider idProvider) {
        return List.of(new Builder(idProvider.generateId(Builder.class), p));
    }

    @Override
    public GameState onTurnPartCleanUp(GameState state) {
        return this.updateModel(state, bs -> {
            if (bs == BuilderState.USED) {
                return BuilderState.SECOND_TURN;
            }
            if (bs == BuilderState.SECOND_TURN) {
                return BuilderState.UNUSED;
            }
            return bs;
        });
    }
}

