/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game.capability;

import com.jcloisterzone.Player;
import com.jcloisterzone.PointCategory;
import com.jcloisterzone.XMLUtils;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.Tile;
import com.jcloisterzone.board.TileModifier;
import com.jcloisterzone.event.play.PlayEvent;
import com.jcloisterzone.event.play.TokenReceivedEvent;
import com.jcloisterzone.feature.Castle;
import com.jcloisterzone.feature.CloisterLike;
import com.jcloisterzone.feature.Scoreable;
import com.jcloisterzone.game.Capability;
import com.jcloisterzone.game.ScoreFeatureReducer;
import com.jcloisterzone.game.Token;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.game.state.PlacedTile;
import com.jcloisterzone.game.state.PlayersState;
import com.jcloisterzone.reducers.AddPoints;
import io.vavr.Tuple2;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import io.vavr.collection.Set;
import io.vavr.collection.Vector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import org.w3c.dom.Element;

public class GoldminesCapability
extends Capability<Map<Position, Integer>> {
    private static final long serialVersionUID = 1L;
    public static final TileModifier GOLDMINE = new TileModifier("Goldmine");

    @Override
    public Tile initTile(GameState state, Tile tile, Vector<Element> tileElements) {
        if (!XMLUtils.getElementStreamByTagName(tileElements, "goldmine").isEmpty()) {
            tile = tile.addTileModifier(GOLDMINE);
        }
        return tile;
    }

    @Override
    public GameState onStartGame(GameState state) {
        return this.setModel(state, HashMap.empty());
    }

    private Set<Position> getFeatureClaimPositions(GameState state, Scoreable feature) {
        if (feature instanceof CloisterLike) {
            Position cloisterPosition = ((CloisterLike)feature).getPosition();
            return state.getAdjacentAndDiagonalTiles(cloisterPosition).map(PlacedTile::getPosition).append(cloisterPosition).toSet();
        }
        if (feature instanceof Castle) {
            return ((Castle)feature).getVicinity();
        }
        return feature.getTilePositions();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public GameState onTurnScoring(GameState state, HashMap<Scoreable, ScoreFeatureReducer> completed) {
        Map<Position, Integer> placedGold = (Map<Position, Integer>)this.getModel(state);
        java.util.HashMap<Position, HashSet<Player>> claimedGold = new java.util.HashMap<Position, HashSet<Player>>();
        for (Tuple2 tuple2 : completed) {
            Scoreable feature = (Scoreable)tuple2._1;
            Set<Player> owners = ((ScoreFeatureReducer)tuple2._2).getOwners();
            if (owners.isEmpty()) continue;
            for (Position position : this.getFeatureClaimPositions(state, feature)) {
                if (!placedGold.containsKey(position)) continue;
                HashSet<Player> claimsOnTile = (HashSet<Player>)claimedGold.get(position);
                if (claimsOnTile == null) {
                    claimsOnTile = new HashSet<Player>();
                    claimedGold.put(position, claimsOnTile);
                }
                claimsOnTile.addAll(owners.toJavaSet());
            }
        }
        java.util.HashMap<Position, Integer> initialGoldCount = new java.util.HashMap<Position, Integer>();
        ArrayList arrayList = new ArrayList(claimedGold.entrySet());
        java.util.HashMap<Object, Integer> awardedGold = new java.util.HashMap<Object, Integer>();
        java.util.HashMap awardedGoldPositions = new java.util.HashMap();
        for (Player player : state.getPlayers().getPlayers()) {
            awardedGold.put(player, 0);
            awardedGoldPositions.put(player, new HashSet());
        }
        Collections.sort(arrayList, new Comparator<Map.Entry<Position, java.util.Set<Player>>>(){

            @Override
            public int compare(Map.Entry<Position, java.util.Set<Player>> o1, Map.Entry<Position, java.util.Set<Player>> o2) {
                return o2.getValue().size() - o1.getValue().size();
            }
        });
        int goldPieces = 0;
        for (Position pos : claimedGold.keySet()) {
            int n = placedGold.get(pos).getOrElse(0);
            goldPieces += n;
            initialGoldCount.put(pos, n);
        }
        Player player = state.getTurnPlayer();
        while (goldPieces > 0) {
            void var10_17;
            for (Map.Entry entry : arrayList) {
                Position pos = (Position)entry.getKey();
                java.util.Set claimingPlayers = (java.util.Set)entry.getValue();
                int piecesOnTile = placedGold.get(pos).getOrElse(0);
                if (piecesOnTile <= 0 || !claimingPlayers.contains(var10_17)) continue;
                --goldPieces;
                awardedGold.put(var10_17, (Integer)awardedGold.get(var10_17) + 1);
                ((java.util.Set)awardedGoldPositions.get(var10_17)).add(pos);
                if (piecesOnTile == 1) {
                    placedGold = placedGold.remove(pos);
                    break;
                }
                placedGold = placedGold.put(pos, piecesOnTile - 1);
                break;
            }
            Player player2 = var10_17.getNextPlayer(state);
        }
        state = this.setModel(state, placedGold);
        for (Map.Entry entry : awardedGold.entrySet()) {
            Player pl = (Player)entry.getKey();
            int count = (Integer)entry.getValue();
            if (count <= 0) continue;
            state = state.mapPlayers(ps -> ps.addTokenCount(pl.getIndex(), GoldToken.GOLD, count));
            TokenReceivedEvent ev = new TokenReceivedEvent(PlayEvent.PlayEventMeta.createWithActivePlayer(state), pl, GoldToken.GOLD, count);
            ev.setSourcePositions(Vector.ofAll((Iterable)awardedGoldPositions.get(pl)));
            state = state.appendEvent(ev);
        }
        return state;
    }

    @Override
    public GameState onFinalScoring(GameState state) {
        PlayersState ps = state.getPlayers();
        for (Player player : ps.getPlayers()) {
            int pieces = ps.getPlayerTokenCount(player.getIndex(), GoldToken.GOLD);
            if (pieces == 0) continue;
            int points = 0;
            points = pieces < 4 ? 1 * pieces : (pieces < 7 ? 2 * pieces : (pieces < 10 ? 3 * pieces : 4 * pieces));
            state = new AddPoints(player, points, PointCategory.GOLD).apply(state);
        }
        return state;
    }

    public static enum GoldToken implements Token
    {
        GOLD;

    }
}

