/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game.capability;

import com.jcloisterzone.PointCategory;
import com.jcloisterzone.XMLUtils;
import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.PlacementOption;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.Tile;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.event.play.ScoreEvent;
import com.jcloisterzone.feature.Cloister;
import com.jcloisterzone.feature.Feature;
import com.jcloisterzone.feature.Scoreable;
import com.jcloisterzone.figure.Meeple;
import com.jcloisterzone.game.Capability;
import com.jcloisterzone.game.ScoreFeatureReducer;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.reducers.UndeployMeeples;
import io.vavr.Predicates;
import io.vavr.Tuple2;
import io.vavr.collection.Array;
import io.vavr.collection.HashMap;
import io.vavr.collection.IndexedSeq;
import io.vavr.collection.Traversable;
import org.w3c.dom.Element;

public final class ShrineCapability
extends Capability<Void> {
    private static final long serialVersionUID = 1L;

    @Override
    public Feature initFeature(GameState settings, String tileId, Feature feature, Element xml) {
        if (feature instanceof Cloister) {
            return ((Cloister)feature).setShrine(XMLUtils.attributeBoolValue(xml, "shrine"));
        }
        return feature;
    }

    @Override
    public GameState onTurnScoring(GameState state, HashMap<Scoreable, ScoreFeatureReducer> completed) {
        GameState _state = state;
        Traversable completedCloisters = ((HashMap)completed.filterValues(r -> r.getOwners().nonEmpty())).keySet().filter(Predicates.instanceOf(Cloister.class)).map(f -> (Cloister)f);
        Traversable challenged = completedCloisters.flatMap(cloister -> {
            Position pos = cloister.getPlace().getPosition();
            return this.getAdjacentCloisters(_state, pos).filter(c -> c.isShrine() ^ cloister.isShrine());
        }).filter(c -> c.isOpen(_state)).distinct();
        for (Cloister cloister2 : challenged) {
            Meeple meeple = (Meeple)cloister2.getMeeples(state).getOrNull();
            if (meeple == null) continue;
            ScoreEvent scoreEvent = new ScoreEvent(0, PointCategory.CLOISTER, false, cloister2.getPlace(), meeple);
            state = state.appendEvent(scoreEvent);
            state = new UndeployMeeples(cloister2, true).apply(state);
        }
        return state;
    }

    @Override
    public boolean isTilePlacementAllowed(GameState state, Tile tile, PlacementOption placement) {
        Cloister opposite;
        Position oppositePos;
        Cloister cloister = this.getCloister(tile);
        if (cloister == null) {
            return true;
        }
        Array<Cloister> cloisters = this.getAdjacentCloisters(state, placement.getPosition());
        IndexedSeq oppositeCloisters = cloisters.filter(c -> c.isShrine() ^ cloister.isShrine());
        if (oppositeCloisters.size() > 1) {
            return false;
        }
        return oppositeCloisters.size() != 1 || ((Array)this.getAdjacentCloisters(state, oppositePos = (opposite = (Cloister)oppositeCloisters.get()).getPlace().getPosition()).filter(c -> c.isShrine() == cloister.isShrine())).isEmpty();
    }

    private Cloister getCloister(Tile tile) {
        return (Cloister)tile.getInitialFeatures().map(Tuple2::_2).filter(Predicates.instanceOf(Cloister.class)).getOrNull();
    }

    private Array<Cloister> getAdjacentCloisters(GameState state, Position pos) {
        return state.getAdjacentAndDiagonalTiles(pos).map(pt -> state.getFeature(new FeaturePointer(pt.getPosition(), Location.CLOISTER))).filter(Predicates.instanceOf(Cloister.class)).map(f -> (Cloister)f).toArray();
    }
}

