/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game.capability;

import com.jcloisterzone.Player;
import com.jcloisterzone.action.MeepleAction;
import com.jcloisterzone.action.TowerPieceAction;
import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.feature.Tower;
import com.jcloisterzone.figure.BigFollower;
import com.jcloisterzone.figure.Follower;
import com.jcloisterzone.figure.Meeple;
import com.jcloisterzone.figure.Phantom;
import com.jcloisterzone.figure.SmallFollower;
import com.jcloisterzone.game.Capability;
import com.jcloisterzone.game.Token;
import com.jcloisterzone.game.state.ActionsState;
import com.jcloisterzone.game.state.GameState;
import io.vavr.Tuple2;
import io.vavr.collection.Array;
import io.vavr.collection.IndexedSeq;
import io.vavr.collection.LinearSeq;
import io.vavr.collection.List;
import io.vavr.collection.Set;
import io.vavr.collection.Stream;
import io.vavr.collection.Vector;

public final class TowerCapability
extends Capability<Array<List<Follower>>> {
    private static final long serialVersionUID = 1L;
    public static final int RANSOM_POINTS = 3;

    private int getInitialPiecesCount(GameState state) {
        switch (state.getPlayers().getPlayers().length()) {
            case 1: 
            case 2: {
                return 10;
            }
            case 3: {
                return 9;
            }
            case 4: {
                return 7;
            }
            case 5: {
                return 6;
            }
            case 6: {
                return 5;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public GameState onStartGame(GameState state) {
        int pieces = this.getInitialPiecesCount(state);
        state = state.mapPlayers(ps -> ps.setTokenCountForAllPlayers(TowerToken.TOWER_PIECE, pieces));
        state = this.setModel(state, Array.fill(state.getPlayers().length(), List::empty));
        return state;
    }

    @Override
    public GameState onActionPhaseEntered(GameState state) {
        Player player = state.getPlayerActions().getPlayer();
        Set occupiedTowers = state.getDeployedMeeples().filter(t -> ((FeaturePointer)t._2).getLocation().equals(Location.TOWER)).map(Tuple2::_2).toSet();
        LinearSeq openTowersStream = Stream.ofAll(state.getFeatureMap()).filter(t -> t._2 instanceof Tower).filter(t -> !occupiedTowers.contains((FeaturePointer)t._1));
        Set openTowersForPiece = openTowersStream.map(Tuple2::_1).toSet();
        Set openTowersForFollower = openTowersStream.filter(t -> ((Tower)t._2).getHeight() > 0).map(Tuple2::_1).toSet();
        ActionsState as = state.getPlayerActions();
        if (!openTowersForPiece.isEmpty() && state.getPlayers().getPlayerTokenCount(player.getIndex(), TowerToken.TOWER_PIECE) > 0) {
            as = as.appendAction(new TowerPieceAction((Set<Position>)openTowersForPiece.map(FeaturePointer::getPosition)));
        }
        if (!openTowersForFollower.isEmpty()) {
            Vector<Meeple> availMeeples = player.getMeeplesFromSupply(state, Vector.of(SmallFollower.class, BigFollower.class, Phantom.class));
            IndexedSeq actions = availMeeples.map(meeple -> new MeepleAction((Meeple)meeple, openTowersForFollower));
            as = as.appendActions(actions).mergeMeepleActions();
        }
        return state.setPlayerActions(as);
    }

    public static enum TowerToken implements Token
    {
        TOWER_PIECE;

    }
}

