/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game.capability;

import com.jcloisterzone.Player;
import com.jcloisterzone.PointCategory;
import com.jcloisterzone.event.play.PlayEvent;
import com.jcloisterzone.event.play.TokenReceivedEvent;
import com.jcloisterzone.feature.City;
import com.jcloisterzone.feature.Feature;
import com.jcloisterzone.feature.Scoreable;
import com.jcloisterzone.game.Capability;
import com.jcloisterzone.game.ScoreFeatureReducer;
import com.jcloisterzone.game.Token;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.game.state.PlayersState;
import com.jcloisterzone.reducers.AddPoints;
import io.vavr.Tuple2;
import io.vavr.collection.HashMap;
import io.vavr.collection.LinearSeq;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import org.w3c.dom.Element;

public class TradeGoodsCapability
extends Capability<Void> {
    private static final long serialVersionUID = 1L;

    @Override
    public GameState onTurnScoring(GameState state, HashMap<Scoreable, ScoreFeatureReducer> completed) {
        for (Feature feature : completed.keySet()) {
            City city;
            Map<TradeGoods, Integer> cityTradeGoods;
            if (!(feature instanceof City) || (cityTradeGoods = (city = (City)feature).getTradeGoods()).isEmpty()) continue;
            int playerIdx = state.getPlayers().getTurnPlayerIndex();
            state = state.mapPlayers(ps -> {
                for (Tuple2 t : cityTradeGoods) {
                    ps = ps.addTokenCount(playerIdx, (Token)t._1, (Integer)t._2);
                }
                return ps;
            });
            for (Tuple2 tuple2 : cityTradeGoods) {
                TokenReceivedEvent ev = new TokenReceivedEvent(PlayEvent.PlayEventMeta.createWithActivePlayer(state), state.getPlayers().getTurnPlayer(), (Token)tuple2._1, (Integer)tuple2._2);
                ev.setSourceFeature(feature);
                state = state.appendEvent(ev);
            }
        }
        return state;
    }

    @Override
    public Feature initFeature(GameState state, String tileId, Feature feature, Element xml) {
        if (feature instanceof City && xml.hasAttribute("resource")) {
            City city = (City)feature;
            String val = xml.getAttribute("resource");
            TradeGoods res = TradeGoods.valueOf(val.toUpperCase());
            return city.setTradeGoods(HashMap.of(res, 1));
        }
        return feature;
    }

    @Override
    public GameState onFinalScoring(GameState state) {
        PlayersState ps = state.getPlayers();
        for (TradeGoods tr : TradeGoods.values()) {
            int hiVal = 1;
            LinearSeq<Object> hiPlayers = List.empty();
            for (Player player : ps.getPlayers()) {
                int playerValue = ps.getPlayerTokenCount(player.getIndex(), tr);
                if (playerValue > hiVal) {
                    hiVal = playerValue;
                    hiPlayers = List.of(player);
                    continue;
                }
                if (playerValue != hiVal) continue;
                hiPlayers = hiPlayers.prepend((Object)player);
            }
            for (Player player : hiPlayers) {
                state = new AddPoints(player, 10, PointCategory.TRADE_GOODS).apply(state);
            }
        }
        return state;
    }

    public static enum TradeGoods implements Token
    {
        WINE,
        CLOTH,
        GRAIN;

    }
}

