/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game.phase;

import com.jcloisterzone.Player;
import com.jcloisterzone.action.MeepleAction;
import com.jcloisterzone.action.PlayerAction;
import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.event.play.FlierRollEvent;
import com.jcloisterzone.event.play.PlayEvent;
import com.jcloisterzone.feature.Cloister;
import com.jcloisterzone.feature.Completable;
import com.jcloisterzone.feature.Farm;
import com.jcloisterzone.feature.FlyingMachine;
import com.jcloisterzone.feature.Road;
import com.jcloisterzone.feature.Structure;
import com.jcloisterzone.feature.Tower;
import com.jcloisterzone.figure.Barn;
import com.jcloisterzone.figure.DeploymentCheckResult;
import com.jcloisterzone.figure.Meeple;
import com.jcloisterzone.figure.Shepherd;
import com.jcloisterzone.figure.Special;
import com.jcloisterzone.game.Capability;
import com.jcloisterzone.game.RandomGenerator;
import com.jcloisterzone.game.Rule;
import com.jcloisterzone.game.capability.BarnCapability;
import com.jcloisterzone.game.capability.PortalCapability;
import com.jcloisterzone.game.phase.Phase;
import com.jcloisterzone.game.phase.PhaseMessageHandler;
import com.jcloisterzone.game.phase.StepResult;
import com.jcloisterzone.game.state.ActionsState;
import com.jcloisterzone.game.state.Flag;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.game.state.PlacedTile;
import com.jcloisterzone.reducers.DeployMeeple;
import com.jcloisterzone.reducers.PayRansom;
import com.jcloisterzone.wsio.message.DeployFlierMessage;
import com.jcloisterzone.wsio.message.DeployMeepleMessage;
import com.jcloisterzone.wsio.message.PayRansomMessage;
import io.vavr.Tuple2;
import io.vavr.collection.HashSet;
import io.vavr.collection.IndexedSeq;
import io.vavr.collection.LinearSeq;
import io.vavr.collection.List;
import io.vavr.collection.Set;
import io.vavr.collection.Stream;
import io.vavr.collection.Vector;

public abstract class AbstractActionPhase
extends Phase {
    public AbstractActionPhase(RandomGenerator random) {
        super(random);
    }

    private boolean isMeepleDeploymentAllowedByCapabilities(GameState state, Position pos) {
        for (Capability capability : state.getCapabilities().toSeq()) {
            if (capability.isMeepleDeploymentAllowed(state, pos)) continue;
            return false;
        }
        return true;
    }

    private Stream<Tuple2<FeaturePointer, Structure>> getAvailableStructures(GameState state, Stream<PlacedTile> tiles, Set<Position> allowCompletedOn) {
        return tiles.flatMap(tile -> {
            Position pos = tile.getPosition();
            if (!this.isMeepleDeploymentAllowedByCapabilities(state, pos)) {
                return Stream.empty();
            }
            LinearSeq<Tuple2<Location, Structure>> places = state.getTileFeatures2(pos, Structure.class);
            if (!state.getBooleanValue(Rule.FARMERS)) {
                places = places.filter(t -> !(t._2 instanceof Farm));
            }
            places = places.filter(t -> !(t._2 instanceof Tower));
            places = places.flatMap(t -> {
                Structure struct = (Structure)t._2;
                if (struct instanceof Cloister && ((Cloister)struct).isMonastery()) {
                    return List.of(t, new Tuple2<Location, Structure>(Location.MONASTERY, (Structure)t._2));
                }
                return List.of(t);
            });
            boolean allowCompleted = allowCompletedOn.contains(pos);
            if (!allowCompleted) {
                places = places.filter(t -> {
                    if (t._1 == Location.MONASTERY) {
                        return true;
                    }
                    return !(t._2 instanceof Completable) || ((Completable)t._2).isOpen(state);
                });
            }
            if (state.hasFlag(Flag.FLYING_MACHINE_USED) || !allowCompleted) {
                places = places.filter(t -> t._1 != Location.FLYING_MACHINE);
            }
            return places.map(t -> t.map1(loc -> new FeaturePointer(pos, (Location)loc)));
        });
    }

    private Set<FeaturePointer> getMeepleAvailableStructures(GameState state, Meeple meeple, Stream<Tuple2<FeaturePointer, Structure>> structures, boolean includeOccupied) {
        if (!includeOccupied) {
            structures = structures.filter(t -> {
                if (meeple instanceof Special) {
                    return true;
                }
                Structure struct = (Structure)t._2;
                Stream<Meeple> meeples = struct instanceof Cloister ? ((Cloister)struct).getMeeplesIncludingMonastery(state) : struct.getMeeples(state);
                if (meeples.find(m -> !(m instanceof Shepherd)).isEmpty()) {
                    return true;
                }
                if (struct instanceof Road && ((Road)struct).isLabyrinth()) {
                    Set segment = ((Road)struct).findSegmentBorderedBy(state, (FeaturePointer)t._1, fp -> ((Road)state.getPlacedTile(fp.getPosition()).getInitialFeaturePartOf(fp.getLocation())).isLabyrinth()).toSet();
                    boolean segmentIsEmpty = Stream.ofAll(state.getDeployedMeeples()).filter(x -> !(x._1 instanceof Shepherd)).filter(x -> segment.contains((FeaturePointer)x._2)).isEmpty();
                    if (segmentIsEmpty) {
                        return true;
                    }
                }
                return false;
            });
        }
        return structures.filter(t -> meeple.isDeploymentAllowed(state, (FeaturePointer)t._1, (Structure)t._2) == DeploymentCheckResult.OK).map(t -> (FeaturePointer)t._1).toSet();
    }

    protected Vector<PlayerAction<?>> prepareMeepleActions(GameState state, Vector<Class<? extends Meeple>> meepleTypes) {
        Player player = state.getTurnPlayer();
        Vector<Meeple> availMeeples = player.getMeeplesFromSupply(state, meepleTypes);
        PlacedTile lastPlaced = state.getLastPlaced();
        Position currentTilePos = lastPlaced.getPosition();
        Stream<PlacedTile> tiles = lastPlaced.getTile().hasModifier(PortalCapability.MAGIC_PORTAL) && !state.getFlags().contains(Flag.PORTAL_USED) ? Stream.ofAll(state.getPlacedTiles().values()) : Stream.of(lastPlaced);
        Stream<Tuple2<FeaturePointer, Structure>> structures = this.getAvailableStructures(state, tiles, HashSet.of(currentTilePos));
        IndexedSeq actions = availMeeples.map(meeple -> {
            Set<FeaturePointer> locations = this.getMeepleAvailableStructures(state, (Meeple)meeple, structures, false);
            MeepleAction action = new MeepleAction((Meeple)meeple, locations);
            return action;
        });
        return ((Vector)actions).filter(action -> !action.isEmpty());
    }

    @Override
    @PhaseMessageHandler
    public StepResult handlePayRansom(GameState state, PayRansomMessage msg) {
        state = new PayRansom(msg.getMeepleId()).apply(state);
        return this.enter(state);
    }

    @PhaseMessageHandler
    public StepResult handleDeployMeeple(GameState state, DeployMeepleMessage msg) {
        FeaturePointer fp = msg.getPointer();
        Meeple m = state.getActivePlayer().getMeepleFromSupply(state, msg.getMeepleId());
        PlacedTile placedTile = state.getLastPlaced();
        if (fp.getLocation() != Location.TOWER && placedTile.getTile().hasModifier(PortalCapability.MAGIC_PORTAL) && !fp.getPosition().equals(placedTile.getPosition())) {
            state = state.addFlag(Flag.PORTAL_USED);
        }
        state = new DeployMeeple(m, fp).apply(state);
        if (m instanceof Barn) {
            state = state.setCapabilityModel(BarnCapability.class, fp);
        }
        state = this.clearActions(state);
        return this.next(state);
    }

    private Position getTargetPosition(Position pos, Location direction, int distance) {
        for (int i = 0; i < distance; ++i) {
            pos = pos.add(direction);
        }
        return pos;
    }

    @PhaseMessageHandler
    public StepResult handleDeployFlier(GameState state, DeployFlierMessage msg) {
        Position target;
        PlacedTile placedTile = state.getLastPlaced();
        FlyingMachine flyingMachine = (FlyingMachine)state.getFeature(msg.getPointer());
        Meeple meeple = state.getActivePlayer().getMeepleFromSupply(state, msg.getMeepleId());
        int distance = this.getRandom().nextInt(3) + 1;
        state = state.addFlag(Flag.FLYING_MACHINE_USED);
        PlacedTile targetTile = (state = state.appendEvent(new FlierRollEvent(PlayEvent.PlayEventMeta.createWithActivePlayer(state), placedTile.getPosition(), distance))).getPlacedTile(target = this.getTargetPosition(placedTile.getPosition(), flyingMachine.getDirection(), distance));
        if (targetTile == null || !this.isMeepleDeploymentAllowedByCapabilities(state, target)) {
            return this.next(state);
        }
        LinearSeq<Tuple2<FeaturePointer, Structure>> structures = this.getAvailableStructures(state, Stream.of(targetTile), HashSet.empty());
        Set<FeaturePointer> options = this.getMeepleAvailableStructures(state, meeple, (Stream<Tuple2<FeaturePointer, Structure>>)(structures = structures.filter(t -> !(t._2 instanceof Farm))), true);
        if (options.isEmpty()) {
            return this.next(state);
        }
        MeepleAction action = new MeepleAction(meeple, options);
        state = state.setPlayerActions(new ActionsState(state.getTurnPlayer(), action, true));
        return this.promote(state);
    }
}

