/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game.phase;

import com.jcloisterzone.Player;
import com.jcloisterzone.action.MeepleAction;
import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.feature.City;
import com.jcloisterzone.feature.Cloister;
import com.jcloisterzone.feature.Completable;
import com.jcloisterzone.feature.Farm;
import com.jcloisterzone.feature.Feature;
import com.jcloisterzone.feature.Road;
import com.jcloisterzone.feature.Scoreable;
import com.jcloisterzone.figure.Meeple;
import com.jcloisterzone.game.RandomGenerator;
import com.jcloisterzone.game.capability.AbbeyCapability;
import com.jcloisterzone.game.phase.Phase;
import com.jcloisterzone.game.phase.PhaseMessageHandler;
import com.jcloisterzone.game.phase.StepResult;
import com.jcloisterzone.game.state.ActionsState;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.game.state.PlacedTile;
import com.jcloisterzone.wsio.message.PassMessage;
import io.vavr.Tuple2;
import io.vavr.collection.List;
import io.vavr.collection.Set;
import io.vavr.collection.Traversable;
import io.vavr.collection.Vector;
import java.util.HashSet;
import java.util.function.Function;

public abstract class AbstractCocScoringPhase
extends Phase {
    public AbstractCocScoringPhase(RandomGenerator random) {
        super(random);
    }

    protected abstract Function<Feature, Boolean> getAllowedFeaturesFilter(GameState var1);

    protected abstract boolean isLast(GameState var1, Player var2, boolean var3);

    private StepResult endPhase(GameState state) {
        state = this.clearActions(state);
        return this.next(state);
    }

    protected StepResult nextPlayer(GameState state, Player player, boolean actionUsed) {
        if (this.isLast(state, player, actionUsed)) {
            return this.endPhase(state);
        }
        return this.processPlayer(state, player.getNextPlayer(state));
    }

    @Override
    public StepResult enter(GameState state) {
        Player player = state.getTurnPlayer().getNextPlayer(state);
        return this.processPlayer(state, player);
    }

    private Class<? extends Scoreable> getFeatureTypeForLocation(Location loc) {
        if (loc == Location.QUARTER_CASTLE) {
            return City.class;
        }
        if (loc == Location.QUARTER_BLACKSMITH) {
            return Road.class;
        }
        if (loc == Location.QUARTER_CATHEDRAL) {
            return Cloister.class;
        }
        if (loc == Location.QUARTER_MARKET) {
            return Farm.class;
        }
        throw new IllegalArgumentException("Illegal location " + loc);
    }

    protected StepResult processPlayer(GameState state, Player player) {
        FeaturePointer countFp = state.getNeutralFigures().getCountDeployment();
        PlacedTile lastPlaced = state.getLastPlaced();
        Position lastPlacedPos = lastPlaced.getPosition();
        HashSet<Completable> justPlacedAbbeyAdjacent = new HashSet<Completable>();
        if (AbbeyCapability.isAbbey(lastPlaced.getTile())) {
            for (Tuple2 tuple2 : state.getAdjacentTiles2(lastPlacedPos)) {
                PlacedTile pt = (PlacedTile)tuple2._2;
                Feature feature = state.getFeaturePartOf(new FeaturePointer(pt.getPosition(), ((Location)tuple2._1).rev()));
                if (!(feature instanceof Completable)) continue;
                justPlacedAbbeyAdjacent.add((Completable)feature);
            }
        }
        Function<Feature, Boolean> filter = this.getAllowedFeaturesFilter(state);
        Vector vector = Location.QUARTERS.filter(quarter -> quarter != countFp.getLocation()).flatMap(quarter -> {
            Set options = state.getFeatures(this.getFeatureTypeForLocation((Location)quarter)).filter(filter::apply).flatMap(Feature::getPlaces).toSet();
            if (options.isEmpty()) {
                return List.empty();
            }
            return state.getDeployedMeeples().filter(t -> ((FeaturePointer)t._2).getLocation() == quarter).map(Tuple2::_1).filter(m -> m.getPlayer().equals(player)).groupBy(Object::getClass).values().map(Traversable::get).map(m -> new MeepleAction((Meeple)m, options, true));
        }).toVector();
        if (vector.isEmpty()) {
            return this.nextPlayer(state, player, false);
        }
        ActionsState as = new ActionsState(player, Vector.narrow(vector), true);
        as = as.mergeMeepleActions();
        return this.promote(state.setPlayerActions(as));
    }

    @Override
    @PhaseMessageHandler
    public StepResult handlePass(GameState state, PassMessage msg) {
        Player player = state.getActivePlayer();
        return this.nextPlayer(state, player, false);
    }
}

