/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game.phase;

import com.jcloisterzone.Player;
import com.jcloisterzone.action.CastleAction;
import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.event.play.CastleCreated;
import com.jcloisterzone.event.play.PlayEvent;
import com.jcloisterzone.feature.Castle;
import com.jcloisterzone.feature.City;
import com.jcloisterzone.figure.Follower;
import com.jcloisterzone.game.RandomGenerator;
import com.jcloisterzone.game.capability.CastleCapability;
import com.jcloisterzone.game.phase.Phase;
import com.jcloisterzone.game.phase.PhaseMessageHandler;
import com.jcloisterzone.game.phase.RequiredCapability;
import com.jcloisterzone.game.phase.StepResult;
import com.jcloisterzone.game.state.ActionsState;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.game.state.PlacedTile;
import com.jcloisterzone.wsio.message.PlaceTokenMessage;
import io.vavr.Tuple2;
import io.vavr.collection.HashSet;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.collection.Set;

@RequiredCapability(value=CastleCapability.class)
public class CastlePhase
extends Phase {
    public CastlePhase(RandomGenerator random) {
        super(random);
    }

    private Set<FeaturePointer> getPlayerOptions(GameState state, Player player) {
        if (state.getPlayers().getPlayerTokenCount(player.getIndex(), CastleCapability.CastleToken.CASTLE) == 0) {
            return HashSet.empty();
        }
        PlacedTile lastPlaced = state.getLastPlaced();
        Position pos = lastPlaced.getPosition();
        return state.getTileFeatures2(pos, City.class).filter(t -> ((City)t._2).isCastleBase()).filter(t -> ((City)t._2).getPlaces().size() == 2).filter(t -> {
            List followers = ((City)t._2).getFollowers(state).toList();
            if (followers.size() != 1) {
                return false;
            }
            return ((Follower)followers.get()).getPlayer().equals(player);
        }).map(t -> new FeaturePointer(pos, (Location)t._1)).toSet();
    }

    private StepResult prepareActions(GameState state, Player continueWith) {
        Player turnPlayer = state.getTurnPlayer();
        Player player = continueWith;
        do {
            Set<FeaturePointer> options;
            if ((options = this.getPlayerOptions(state, player)).isEmpty()) continue;
            CastleAction action = new CastleAction(options);
            ActionsState as = new ActionsState(player, action, true);
            return this.promote(state.setPlayerActions(as));
        } while (!(player = player.getNextPlayer(state)).equals(turnPlayer));
        return this.next(state);
    }

    @Override
    public StepResult enter(GameState state) {
        return this.prepareActions(state, state.getTurnPlayer());
    }

    @PhaseMessageHandler
    public StepResult handlePlaceTokenMessage(GameState state, PlaceTokenMessage msg) {
        if (msg.getToken() != CastleCapability.CastleToken.CASTLE) {
            throw new IllegalArgumentException();
        }
        Player player = state.getActivePlayer();
        City city = (City)state.getFeature((FeaturePointer)msg.getPointer());
        Castle castle = new Castle(city.getPlaces());
        Map update = city.getPlaces().toMap(ptr -> new Tuple2<FeaturePointer, Castle>((FeaturePointer)ptr, castle));
        state = state.mapPlayers(ps -> ps.addTokenCount(player.getIndex(), CastleCapability.CastleToken.CASTLE, -1));
        state = state.mapFeatureMap(m -> update.merge(m));
        state = state.appendEvent(new CastleCreated(PlayEvent.PlayEventMeta.createWithPlayer(player), castle));
        Player nextPlayer = player.getNextPlayer(state);
        if (nextPlayer.equals((state = this.clearActions(state)).getTurnPlayer())) {
            return this.next(state);
        }
        return this.prepareActions(state, nextPlayer);
    }
}

