/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game.phase;

import com.jcloisterzone.Player;
import com.jcloisterzone.action.CornCircleSelectDeployOrRemoveAction;
import com.jcloisterzone.action.MeepleAction;
import com.jcloisterzone.action.PlayerAction;
import com.jcloisterzone.action.ReturnMeepleAction;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.board.pointer.MeeplePointer;
import com.jcloisterzone.feature.City;
import com.jcloisterzone.feature.Farm;
import com.jcloisterzone.feature.Feature;
import com.jcloisterzone.figure.BigFollower;
import com.jcloisterzone.figure.Follower;
import com.jcloisterzone.figure.Mayor;
import com.jcloisterzone.figure.Meeple;
import com.jcloisterzone.figure.Phantom;
import com.jcloisterzone.figure.SmallFollower;
import com.jcloisterzone.figure.Wagon;
import com.jcloisterzone.game.RandomGenerator;
import com.jcloisterzone.game.capability.CornCircleCapability;
import com.jcloisterzone.game.phase.Phase;
import com.jcloisterzone.game.phase.PhaseMessageHandler;
import com.jcloisterzone.game.phase.RequiredCapability;
import com.jcloisterzone.game.phase.StepResult;
import com.jcloisterzone.game.state.ActionsState;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.game.state.PlacedTile;
import com.jcloisterzone.reducers.DeployMeeple;
import com.jcloisterzone.reducers.UndeployMeeple;
import com.jcloisterzone.wsio.message.CornCircleRemoveOrDeployMessage;
import com.jcloisterzone.wsio.message.DeployMeepleMessage;
import com.jcloisterzone.wsio.message.PassMessage;
import com.jcloisterzone.wsio.message.ReturnMeepleMessage;
import io.vavr.Tuple2;
import io.vavr.collection.IndexedSeq;
import io.vavr.collection.LinearSeq;
import io.vavr.collection.Set;
import io.vavr.collection.Stream;
import io.vavr.collection.Vector;

@RequiredCapability(value=CornCircleCapability.class)
public class CornCirclePhase
extends Phase {
    public CornCirclePhase(RandomGenerator random) {
        super(random);
    }

    private Class<? extends Feature> getCornType(GameState state) {
        PlacedTile placedTile = state.getLastPlaced();
        return (Class)placedTile.getTile().getTileModifiers().find(m -> m instanceof CornCircleCapability.CornCircleModifier).map(m -> ((CornCircleCapability.CornCircleModifier)m).getFeatureType()).getOrNull();
    }

    @Override
    public StepResult enter(GameState state) {
        Class<? extends Feature> cornType = this.getCornType(state);
        if (cornType == null || state.getDeployedMeeples().isEmpty()) {
            return this.next(state);
        }
        CornCircleSelectDeployOrRemoveAction action = new CornCircleSelectDeployOrRemoveAction();
        ActionsState as = new ActionsState(state.getTurnPlayer(), action, false);
        return this.promote(state.setPlayerActions(as));
    }

    @PhaseMessageHandler
    public StepResult handleCornCircleRemoveOrDeployMessage(GameState state, CornCircleRemoveOrDeployMessage msg) {
        state = state.setCapabilityModel(CornCircleCapability.class, msg.getValue());
        Player player = state.getTurnPlayer().getNextPlayer(state);
        return this.createAction(state, player);
    }

    private boolean isLast(GameState state, Player player) {
        return state.getTurnPlayer().equals(player);
    }

    private StepResult endPhase(GameState state) {
        state = this.clearActions(state);
        return this.next(state);
    }

    private StepResult nextCornPlayer(GameState state, Player player) {
        if (this.isLast(state, player)) {
            return this.endPhase(state);
        }
        return this.createAction(state, player.getNextPlayer(state));
    }

    private StepResult createAction(GameState state, Player player) {
        CornCircleRemoveOrDeployMessage.CornCircleOption option = (CornCircleRemoveOrDeployMessage.CornCircleOption)((Object)state.getCapabilityModel(CornCircleCapability.class));
        Class<? extends Feature> cornType = this.getCornType(state);
        LinearSeq followers = Stream.ofAll(state.getDeployedMeeples()).filter(t -> t._1 instanceof Follower).filter(t -> ((Meeple)t._1).getPlayer().equals(player)).filter(t -> cornType.isInstance(state.getFeature((FeaturePointer)t._2)));
        if (followers.isEmpty()) {
            return this.nextCornPlayer(state, player);
        }
        IndexedSeq<ReturnMeepleAction> actions = null;
        switch (option) {
            case DEPLOY: {
                Vector<Meeple> availMeeples;
                IndexedSeq meepleTypes = Vector.of(SmallFollower.class, BigFollower.class, Phantom.class);
                if (!cornType.equals(Farm.class)) {
                    meepleTypes = ((Vector)meepleTypes).append(Wagon.class);
                }
                if (cornType.equals(City.class)) {
                    meepleTypes = ((Vector)meepleTypes).append(Mayor.class);
                }
                if ((availMeeples = player.getMeeplesFromSupply(state, (Vector<Class<? extends Meeple>>)meepleTypes)).isEmpty()) {
                    return this.nextCornPlayer(state, player);
                }
                Set deployOptions = followers.map(Tuple2::_2).toSet();
                actions = availMeeples.map(meeple -> new MeepleAction((Meeple)meeple, deployOptions));
                break;
            }
            case REMOVE: {
                Set<MeeplePointer> removeOptions = followers.map(MeeplePointer::new).toSet();
                actions = Vector.of(new ReturnMeepleAction(removeOptions, ReturnMeepleMessage.ReturnMeepleSource.CORN_CIRCLE));
            }
        }
        return this.promote(state.setPlayerActions(new ActionsState(player, (Vector<PlayerAction<?>>)actions, option == CornCircleRemoveOrDeployMessage.CornCircleOption.DEPLOY)));
    }

    @PhaseMessageHandler
    public StepResult handleDeployMeeple(GameState state, DeployMeepleMessage msg) {
        CornCircleRemoveOrDeployMessage.CornCircleOption option = (CornCircleRemoveOrDeployMessage.CornCircleOption)((Object)state.getCapabilityModel(CornCircleCapability.class));
        if (option != CornCircleRemoveOrDeployMessage.CornCircleOption.DEPLOY) {
            throw new IllegalStateException();
        }
        Player player = state.getActivePlayer();
        FeaturePointer fp = msg.getPointer();
        Meeple m = state.getActivePlayer().getMeepleFromSupply(state, msg.getMeepleId());
        state = new DeployMeeple(m, fp).apply(state);
        return this.nextCornPlayer(state, player);
    }

    @PhaseMessageHandler
    public StepResult handleReturnMeeple(GameState state, ReturnMeepleMessage msg) {
        CornCircleRemoveOrDeployMessage.CornCircleOption option = (CornCircleRemoveOrDeployMessage.CornCircleOption)((Object)state.getCapabilityModel(CornCircleCapability.class));
        if (option != CornCircleRemoveOrDeployMessage.CornCircleOption.REMOVE) {
            throw new IllegalStateException();
        }
        MeeplePointer ptr = msg.getPointer();
        if (msg.getSource() != ReturnMeepleMessage.ReturnMeepleSource.CORN_CIRCLE) {
            throw new IllegalStateException();
        }
        Player player = state.getActivePlayer();
        Meeple meeple = (Meeple)state.getDeployedMeeples().find(m -> ptr.match((Meeple)m._1)).map(t -> (Meeple)t._1).getOrElseThrow(() -> new IllegalArgumentException("Pointer doesn't match any meeple"));
        state = new UndeployMeeple(meeple, true).apply(state);
        return this.nextCornPlayer(state, player);
    }

    @Override
    @PhaseMessageHandler
    public StepResult handlePass(GameState state, PassMessage msg) {
        CornCircleRemoveOrDeployMessage.CornCircleOption option = (CornCircleRemoveOrDeployMessage.CornCircleOption)((Object)state.getCapabilityModel(CornCircleCapability.class));
        if (option != CornCircleRemoveOrDeployMessage.CornCircleOption.DEPLOY) {
            throw new IllegalStateException();
        }
        Player player = state.getActivePlayer();
        return this.nextCornPlayer(state, player);
    }
}

