/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game.phase;

import com.jcloisterzone.Player;
import com.jcloisterzone.action.EscapeAction;
import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.board.pointer.MeeplePointer;
import com.jcloisterzone.feature.City;
import com.jcloisterzone.figure.Follower;
import com.jcloisterzone.figure.Meeple;
import com.jcloisterzone.game.RandomGenerator;
import com.jcloisterzone.game.Rule;
import com.jcloisterzone.game.capability.SiegeCapability;
import com.jcloisterzone.game.phase.Phase;
import com.jcloisterzone.game.phase.PhaseMessageHandler;
import com.jcloisterzone.game.phase.RequiredCapability;
import com.jcloisterzone.game.phase.StepResult;
import com.jcloisterzone.game.state.ActionsState;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.game.state.PlacedTile;
import com.jcloisterzone.reducers.UndeployMeeple;
import com.jcloisterzone.wsio.message.ReturnMeepleMessage;
import io.vavr.collection.LinearSeq;
import io.vavr.collection.Set;
import io.vavr.collection.Stream;
import java.util.function.Function;
import java.util.function.Predicate;

@RequiredCapability(value=SiegeCapability.class)
public class EscapePhase
extends Phase {
    public EscapePhase(RandomGenerator random) {
        super(random);
    }

    @Override
    public StepResult enter(GameState state) {
        Player player = state.getTurnPlayer();
        LinearSeq cities = state.getFeatures(City.class).filter(c -> c.isBesieged()).filter(c -> c.isOccupiedBy(state, player));
        Function<City, Stream> getCityFollowers = city -> city.getFollowers2(state).filter(t -> ((Follower)t._1).getPlayer().equals(player)).map(MeeplePointer::new);
        Predicate<Position> cloisterExists = pos -> state.getFeature(new FeaturePointer((Position)pos, Location.CLOISTER)) != null;
        Set<MeeplePointer> options = cities.filter(c -> {
            LinearSeq cityTiles = Stream.ofAll(c.getTilePositions()).map(state::getPlacedTile);
            if (!state.getBooleanValue(Rule.ESCAPE_RGG)) {
                cityTiles = cityTiles.filter(pt -> pt.getTile().hasModifier(SiegeCapability.SIEGE_ESCAPE_TILE));
            }
            LinearSeq adjacent = cityTiles.map(PlacedTile::getPosition).flatMap(state::getAdjacentAndDiagonalTiles);
            return Stream.concat(cityTiles, adjacent).distinct().map(PlacedTile::getPosition).find(cloisterExists).isDefined();
        }).flatMap(getCityFollowers).toSet();
        if (options.isEmpty()) {
            return this.next(state);
        }
        return this.promote(state.setPlayerActions(new ActionsState(player, new EscapeAction(options), true)));
    }

    @PhaseMessageHandler
    public StepResult handleReturnMeeple(GameState state, ReturnMeepleMessage msg) {
        MeeplePointer ptr = msg.getPointer();
        Meeple meeple = (Meeple)state.getDeployedMeeples().find(m -> ptr.match((Meeple)m._1)).map(t -> (Meeple)t._1).getOrElseThrow(() -> new IllegalArgumentException("Pointer doesn't match any meeple"));
        switch (msg.getSource()) {
            case SIEGE_ESCAPE: {
                EscapeAction princessAction = (EscapeAction)state.getAction();
                if (princessAction.getOptions().contains(ptr)) break;
                throw new IllegalArgumentException("Pointer doesn't match action");
            }
            default: {
                throw new IllegalArgumentException("Return meeple is not allowed");
            }
        }
        state = new UndeployMeeple(meeple, true).apply(state);
        state = this.clearActions(state);
        return this.next(state);
    }
}

