/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game.phase;

import com.jcloisterzone.action.NeutralFigureAction;
import com.jcloisterzone.action.PlayerAction;
import com.jcloisterzone.action.RemovMageOrWithAction;
import com.jcloisterzone.board.Tile;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.feature.City;
import com.jcloisterzone.feature.Completable;
import com.jcloisterzone.feature.Feature;
import com.jcloisterzone.feature.Road;
import com.jcloisterzone.figure.neutral.Mage;
import com.jcloisterzone.figure.neutral.NeutralFigure;
import com.jcloisterzone.figure.neutral.Witch;
import com.jcloisterzone.game.RandomGenerator;
import com.jcloisterzone.game.capability.MageAndWitchCapability;
import com.jcloisterzone.game.phase.Phase;
import com.jcloisterzone.game.phase.PhaseMessageHandler;
import com.jcloisterzone.game.phase.RequiredCapability;
import com.jcloisterzone.game.phase.StepResult;
import com.jcloisterzone.game.state.ActionsState;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.game.state.NeutralFiguresState;
import com.jcloisterzone.reducers.MoveNeutralFigure;
import com.jcloisterzone.wsio.message.MoveNeutralFigureMessage;
import io.vavr.collection.HashSet;
import io.vavr.collection.LinearSeq;
import io.vavr.collection.Set;
import io.vavr.collection.Vector;

@RequiredCapability(value=MageAndWitchCapability.class)
public class MageAndWitchPhase
extends Phase {
    public MageAndWitchPhase(RandomGenerator random) {
        super(random);
    }

    @Override
    public StepResult enter(GameState state) {
        boolean mageAndWithOnSameFeature;
        Tile tile = state.getLastPlaced().getTile();
        NeutralFiguresState ns = state.getNeutralFigures();
        Completable mageFeature = (Completable)ns.getMage().getFeature(state);
        Completable witchFeature = (Completable)ns.getWitch().getFeature(state);
        boolean bl = mageAndWithOnSameFeature = mageFeature != null && mageFeature == witchFeature;
        if (!tile.hasModifier(MageAndWitchCapability.MAGE_TRIGGER) && !mageAndWithOnSameFeature) {
            return this.next(state);
        }
        GameState _state = state;
        LinearSeq targetFeatures = state.getFeatures(Completable.class).filter(f -> f != mageFeature && f != witchFeature).filter(f -> f instanceof Road || f instanceof City).filter(f -> f.isOpen(_state));
        if (targetFeatures.isEmpty()) {
            if (mageFeature != null && witchFeature != null) {
                RemovMageOrWithAction action = new RemovMageOrWithAction((Set<NeutralFigure<FeaturePointer>>)HashSet.of(ns.getMage(), ns.getWitch()));
                return this.promote(state.setPlayerActions(new ActionsState(state.getTurnPlayer(), action, false)));
            }
            if (mageFeature != null) {
                state = new MoveNeutralFigure<Object>(ns.getMage(), null).apply(state);
            }
            if (witchFeature != null) {
                state = new MoveNeutralFigure<Object>(ns.getWitch(), null).apply(state);
            }
            return this.next(state);
        }
        Set<FeaturePointer> options = targetFeatures.flatMap(Feature::getPlaces).toSet();
        Vector<PlayerAction<?>> actions = Vector.of(new NeutralFigureAction(ns.getMage(), options), new NeutralFigureAction(ns.getWitch(), options));
        return this.promote(state.setPlayerActions(new ActionsState(state.getTurnPlayer(), actions, false)));
    }

    @PhaseMessageHandler
    public StepResult handleMoveNeutralFigure(GameState state, MoveNeutralFigureMessage msg) {
        FeaturePointer ptr = (FeaturePointer)msg.getTo();
        NeutralFigure<?> fig = state.getNeutralFigures().getById(msg.getFigureId());
        if (fig instanceof Mage || fig instanceof Witch) {
            state = new MoveNeutralFigure<FeaturePointer>(fig, ptr, state.getActivePlayer()).apply(state);
            state = this.clearActions(state);
            return this.next(state);
        }
        throw new IllegalArgumentException("Illegal neutral figure move");
    }
}

