/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game.phase;

import com.jcloisterzone.Player;
import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.ShortEdge;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.event.play.TokenPlacedEvent;
import com.jcloisterzone.feature.Castle;
import com.jcloisterzone.feature.City;
import com.jcloisterzone.feature.Cloister;
import com.jcloisterzone.feature.CloisterLike;
import com.jcloisterzone.feature.Completable;
import com.jcloisterzone.feature.Farm;
import com.jcloisterzone.feature.Feature;
import com.jcloisterzone.feature.Road;
import com.jcloisterzone.feature.Scoreable;
import com.jcloisterzone.figure.Barn;
import com.jcloisterzone.figure.Builder;
import com.jcloisterzone.figure.Meeple;
import com.jcloisterzone.figure.Wagon;
import com.jcloisterzone.game.Capability;
import com.jcloisterzone.game.RandomGenerator;
import com.jcloisterzone.game.ScoreFeatureReducer;
import com.jcloisterzone.game.capability.AbbeyCapability;
import com.jcloisterzone.game.capability.BarnCapability;
import com.jcloisterzone.game.capability.BuilderCapability;
import com.jcloisterzone.game.capability.CastleCapability;
import com.jcloisterzone.game.capability.FerriesCapability;
import com.jcloisterzone.game.capability.FerriesCapabilityModel;
import com.jcloisterzone.game.capability.TunnelCapability;
import com.jcloisterzone.game.capability.WagonCapability;
import com.jcloisterzone.game.phase.Phase;
import com.jcloisterzone.game.phase.StepResult;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.game.state.PlacedTile;
import com.jcloisterzone.reducers.ScoreCompletable;
import com.jcloisterzone.reducers.ScoreFarm;
import com.jcloisterzone.reducers.ScoreFarmWhenBarnIsConnected;
import com.jcloisterzone.reducers.UndeployMeeples;
import io.vavr.Predicates;
import io.vavr.Tuple2;
import io.vavr.collection.Array;
import io.vavr.collection.LinearSeq;
import io.vavr.collection.LinkedHashMap;
import io.vavr.collection.List;
import io.vavr.collection.Queue;
import io.vavr.collection.Set;
import io.vavr.control.Option;
import java.util.HashMap;
import java.util.Map;

public class ScoringPhase
extends Phase {
    private Map<Completable, ScoreFeatureReducer> completedMutable = new HashMap<Completable, ScoreFeatureReducer>();

    public ScoringPhase(RandomGenerator random) {
        super(random);
    }

    private GameState scoreCompletedOnTile(GameState state, PlacedTile tile) {
        for (Tuple2 tuple2 : state.getTileFeatures2(tile.getPosition(), Completable.class)) {
            state = this.scoreCompleted(state, (Completable)tuple2._2, tile);
        }
        return state;
    }

    private GameState scoreClosedByFerries(GameState state) {
        for (Tuple2 tuple2 : ((FerriesCapabilityModel)state.getCapabilityModel(FerriesCapability.class)).getMovedFerries()) {
            Location from = (Location)((Tuple2)tuple2._2)._1;
            Location to = (Location)((Tuple2)tuple2._2)._2;
            LinearSeq affected = from.subtract(to).splitToSides().map(loc -> new FeaturePointer((Position)t._1, (Location)loc));
            affected = affected.append(new FeaturePointer((Position)tuple2._1, (Location)to.subtract(from).splitToSides().get()));
            for (FeaturePointer fp : affected) {
                Road road = (Road)state.getFeature(fp);
                state = this.scoreCompleted(state, road, null);
            }
        }
        return state;
    }

    private GameState scoreCompletedNearAbbey(GameState state, Position pos) {
        for (Tuple2 tuple2 : state.getAdjacentTiles2(pos)) {
            PlacedTile pt = (PlacedTile)tuple2._2;
            FeaturePointer fp = new FeaturePointer(pt.getPosition(), ((Location)tuple2._1).rev());
            Feature feature = state.getFeaturePartOf(fp);
            if (feature instanceof Completable) {
                state = this.scoreCompleted(state, (Completable)feature, null);
            }
            if (!(feature instanceof City)) continue;
            City city = (City)feature;
            ShortEdge edge = new ShortEdge(pos, pt.getPosition());
            Tuple2 multiEdge = (Tuple2)city.getMultiEdges().find(me -> ((ShortEdge)me._1).equals(edge)).getOrNull();
            if (multiEdge == null) continue;
            City another = (City)state.getFeature((FeaturePointer)multiEdge._2);
            state = this.scoreCompleted(state, another, null);
        }
        return state;
    }

    @Override
    public StepResult enter(GameState state) {
        Object _state;
        PlacedTile lastPlaced = state.getLastPlaced();
        Position pos = lastPlaced.getPosition();
        io.vavr.collection.Map<Wagon, FeaturePointer> deployedWagonsBefore = this.getDeployedWagons(state);
        if (state.getCapabilities().contains(BarnCapability.class)) {
            Farm placedBarnFarm;
            FeaturePointer placedBarnPtr = (FeaturePointer)state.getCapabilityModel(BarnCapability.class);
            Farm farm = placedBarnFarm = placedBarnPtr == null ? null : (Farm)state.getFeature(placedBarnPtr);
            if (placedBarnFarm != null) {
                state = new ScoreFarm(placedBarnFarm, false).apply(state);
                state = new UndeployMeeples(placedBarnFarm, false).apply(state);
            }
            _state = state;
            for (Farm farm2 : state.getTileFeatures2(pos).map(Tuple2::_2).filter(f -> f != placedBarnFarm).filter(Predicates.instanceOf(Farm.class)).map(f -> (Farm)f).filter(arg_0 -> ScoringPhase.lambda$enter$4((GameState)_state, arg_0))) {
                state = new ScoreFarmWhenBarnIsConnected(farm2).apply(state);
                state = new UndeployMeeples(farm2, false).apply(state);
            }
        }
        state = this.scoreCompletedOnTile(state, lastPlaced);
        if (AbbeyCapability.isAbbey(lastPlaced.getTile())) {
            state = this.scoreCompletedNearAbbey(state, pos);
        }
        if (state.getCapabilities().contains(FerriesCapability.class)) {
            state = this.scoreClosedByFerries(state);
        }
        if (state.getCapabilities().contains(TunnelCapability.class)) {
            GameState _state2 = state;
            LinearSeq tunnelModified = state.getCurrentTurnEvents().filter(Predicates.instanceOf(TokenPlacedEvent.class)).map(ev -> (TokenPlacedEvent)ev).filter(ev -> ev.getToken() instanceof TunnelCapability.Tunnel).map(ev -> _state2.getFeature((FeaturePointer)ev.getPointer()));
            assert (tunnelModified.size() <= 1);
            _state = tunnelModified.iterator();
            while (_state.hasNext()) {
                Feature road = (Feature)_state.next();
                state = this.scoreCompleted(state, (Completable)road, null);
            }
        }
        Set<Position> neighbourPositions = state.getAdjacentAndDiagonalTiles2(pos).map(pt -> ((PlacedTile)pt._2).getPosition()).toSet();
        for (CloisterLike cloister : state.getFeatures(CloisterLike.class)) {
            if (!neighbourPositions.contains(cloister.getPosition())) continue;
            state = this.scoreCompleted(state, cloister, null);
        }
        CastleCapability castleCap = state.getCapabilities().get(CastleCapability.class);
        io.vavr.collection.HashMap<Completable, ScoreFeatureReducer> completed = io.vavr.collection.HashMap.ofAll(this.completedMutable);
        io.vavr.collection.HashMap<Scoreable, ScoreFeatureReducer> scored = io.vavr.collection.HashMap.narrow(completed);
        if (castleCap != null) {
            Tuple2<GameState, io.vavr.collection.Map<Castle, ScoreFeatureReducer>> castleRes = castleCap.scoreCastles(state, completed);
            state = (GameState)castleRes._1;
            scored = scored.merge((io.vavr.collection.Map)castleRes._2);
        }
        for (Capability capability : state.getCapabilities().toSeq()) {
            state = capability.onTurnScoring(state, scored);
        }
        if (!deployedWagonsBefore.isEmpty()) {
            Set<Wagon> deployedWagonsAfter = this.getDeployedWagons(state).keySet();
            Set<Wagon> set = deployedWagonsBefore.keySet().diff(deployedWagonsAfter);
            Queue model = ((Array)((Array)state.getPlayers().getPlayersBeginWith(state.getTurnPlayer()).map(p -> (Wagon)returnedVagons.find(w -> w.getPlayer().equals(p)).getOrNull())).filter(Predicates.isNotNull())).map(w -> new Tuple2<Wagon, FeaturePointer>((Wagon)w, (FeaturePointer)deployedWagonsBefore.get((Wagon)w).get())).toQueue();
            state = state.setCapabilityModel(WagonCapability.class, model);
        }
        this.completedMutable.clear();
        return this.next(state);
    }

    private io.vavr.collection.Map<Wagon, FeaturePointer> getDeployedWagons(GameState state) {
        return ((LinkedHashMap)state.getDeployedMeeples().filter((m, fp) -> m instanceof Wagon)).mapKeys(m -> (Wagon)m);
    }

    private GameState scoreCompleted(GameState state, Completable completable, PlacedTile triggerBuilderForPlaced) {
        if (triggerBuilderForPlaced != null && state.getCapabilities().contains(BuilderCapability.class)) {
            Player player = state.getTurnPlayer();
            GameState _state = state;
            Option<Meeple> builder = completable.getMeeples(state).find(m -> m instanceof Builder && m.getPlayer().equals(player) && !m.getPosition(_state).equals(triggerBuilderForPlaced.getPosition()));
            if (!builder.isEmpty()) {
                state = state.getCapabilities().get(BuilderCapability.class).useBuilder(state);
            }
        }
        if (completable.isCompleted(state) && !this.completedMutable.containsKey(completable)) {
            Cloister monastery;
            List meeples;
            if (completable instanceof Cloister && ((Cloister)completable).isMonastery() && (meeples = (monastery = (Cloister)completable).getMeeplesIncludingMonastery2(state).toList()).size() > 0 && meeples.filter(t -> ((FeaturePointer)t._2).getLocation() == Location.CLOISTER).size() == 0) {
                return state;
            }
            ScoreCompletable scoreReducer = new ScoreCompletable(completable, false);
            state = scoreReducer.apply(state);
            state = new UndeployMeeples(completable, false).apply(state);
            this.completedMutable.put(completable, scoreReducer);
        }
        return state;
    }

    private static /* synthetic */ boolean lambda$enter$4(GameState _state, Farm farm) {
        return farm.getSpecialMeeples(_state).find(Predicates.instanceOf(Barn.class)).isDefined();
    }
}

