/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game.save;

import com.google.gson.annotations.JsonAdapter;
import com.jcloisterzone.Expansion;
import com.jcloisterzone.game.Capability;
import com.jcloisterzone.game.Game;
import com.jcloisterzone.game.GameSetup;
import com.jcloisterzone.game.PlayerSlot;
import com.jcloisterzone.game.Rule;
import com.jcloisterzone.ui.JCloisterZone;
import com.jcloisterzone.wsio.message.WsReplayableMessage;
import com.jcloisterzone.wsio.message.adapters.CapabilitiesSetAdapter;
import com.jcloisterzone.wsio.message.adapters.ExpansionMapAdapter;
import com.jcloisterzone.wsio.message.adapters.RulesMapAdapter;
import io.vavr.collection.HashMap;
import io.vavr.collection.HashSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SavedGame
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String gameId;
    private String name;
    private String appVersion;
    private long initialSeed;
    private Date created;
    private List<SavedGamePlayerSlot> slots;
    private long clock;
    private SavedGameSetup setup;
    private List<WsReplayableMessage> replay;
    private java.util.HashMap<String, Object> annotations;

    public SavedGame() {
    }

    public SavedGame(Game game) {
        this.gameId = game.getGameId();
        this.name = game.getName();
        this.appVersion = JCloisterZone.VERSION;
        this.initialSeed = game.getInitialSeed();
        this.created = new Date();
        this.slots = new ArrayList<SavedGamePlayerSlot>();
        for (PlayerSlot slot : game.getPlayerSlots()) {
            if (slot == null || !slot.isOccupied()) continue;
            this.slots.add(new SavedGamePlayerSlot(slot.getNumber(), slot.getSerial(), slot.getClientId(), slot.getNickname(), slot.getAiClassName()));
        }
        this.clock = System.currentTimeMillis() - game.getClockStart();
        this.setup = new SavedGameSetup();
        this.setup.setExpansions(game.getSetup().getExpansions().toJavaMap());
        this.setup.setRules(game.getSetup().getRules().toJavaMap());
        this.setup.setCapabilities(game.getSetup().getCapabilities().toJavaSet());
        this.replay = game.getReplay().reverse().toJavaList();
    }

    public SavedGameSetup getSetup() {
        return this.setup;
    }

    public void setSetup(SavedGameSetup setup) {
        this.setup = setup;
    }

    public List<WsReplayableMessage> getReplay() {
        return this.replay;
    }

    public void setReplay(List<WsReplayableMessage> replay) {
        this.replay = replay;
    }

    public String getGameId() {
        return this.gameId;
    }

    public void setGameId(String gameId) {
        this.gameId = gameId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public long getInitialSeed() {
        return this.initialSeed;
    }

    public void setInitialSeed(long initialSeed) {
        this.initialSeed = initialSeed;
    }

    public List<SavedGamePlayerSlot> getSlots() {
        return this.slots;
    }

    public void setSlots(List<SavedGamePlayerSlot> slots) {
        this.slots = slots;
    }

    public long getClock() {
        return this.clock;
    }

    public void setClock(long clock) {
        this.clock = clock;
    }

    public java.util.HashMap<String, Object> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(java.util.HashMap<String, Object> annotations) {
        this.annotations = annotations;
    }

    public static class SavedGamePlayerSlot {
        private final int number;
        private Integer serial;
        private String clientId;
        private String nickname;
        private String aiClassName;

        public SavedGamePlayerSlot(int number, Integer serial, String clientId, String nickname, String aiClassName) {
            this.number = number;
            this.serial = serial;
            this.clientId = clientId;
            this.nickname = nickname;
            this.aiClassName = aiClassName;
        }

        public Integer getSerial() {
            return this.serial;
        }

        public void setSerial(Integer serial) {
            this.serial = serial;
        }

        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public String getNickname() {
            return this.nickname;
        }

        public void setNickname(String nickname) {
            this.nickname = nickname;
        }

        public String getAiClassName() {
            return this.aiClassName;
        }

        public void setAiClassName(String aiClassName) {
            this.aiClassName = aiClassName;
        }

        public int getNumber() {
            return this.number;
        }
    }

    public static class SavedGameSetup {
        @JsonAdapter(value=ExpansionMapAdapter.class)
        private Map<Expansion, Integer> expansions;
        @JsonAdapter(value=RulesMapAdapter.class)
        private Map<Rule, Object> rules;
        @JsonAdapter(value=CapabilitiesSetAdapter.class)
        private Set<Class<? extends Capability<?>>> capabilities;

        public Map<Expansion, Integer> getExpansions() {
            return this.expansions;
        }

        public void setExpansions(Map<Expansion, Integer> expansions) {
            this.expansions = expansions;
        }

        public Map<Rule, Object> getRules() {
            return this.rules;
        }

        public void setRules(Map<Rule, Object> rules) {
            this.rules = rules;
        }

        public Set<Class<? extends Capability<?>>> getCapabilities() {
            return this.capabilities;
        }

        public void setCapabilities(Set<Class<? extends Capability<?>>> capabilities) {
            this.capabilities = capabilities;
        }

        public GameSetup asGameSetup() {
            return new GameSetup(HashMap.ofAll(this.expansions), HashSet.ofAll(this.capabilities), HashMap.ofAll(this.rules));
        }
    }
}

