/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game.save;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.jcloisterzone.VersionComparator;
import com.jcloisterzone.game.Rule;
import com.jcloisterzone.game.save.SavedGame;
import com.jcloisterzone.wsio.MessageParser;
import com.jcloisterzone.wsio.message.AbstractWsMessage;
import com.jcloisterzone.wsio.message.WsReplayableMessage;
import java.io.Writer;
import java.lang.reflect.Type;

public class SavedGameParser {
    private Gson gson;

    public SavedGameParser() {
        this(false);
    }

    public SavedGameParser(boolean pretty) {
        GsonBuilder builder = MessageParser.createGsonBuilder();
        builder.setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").setExclusionStrategies(new SavedGameExclStrat());
        if (pretty) {
            builder.setPrettyPrinting();
        }
        this.gson = builder.create();
    }

    public String toJson(SavedGame src) {
        return this.gson.toJson(src);
    }

    public void toJson(SavedGame src, Writer writer) {
        this.gson.toJson((Object)src, (Appendable)writer);
    }

    public SavedGame fromJson(JsonReader reader) {
        SavedGame sg = (SavedGame)this.gson.fromJson(reader, (Type)((Object)SavedGame.class));
        if (!"dev-snapshot".equals(sg.getAppVersion()) && new VersionComparator().compare(sg.getAppVersion(), "4.6.0") < 0) {
            sg.getSetup().getRules().put(Rule.FARMERS, Boolean.TRUE);
        }
        int msgIdCounter = 1;
        for (WsReplayableMessage msg : sg.getReplay()) {
            msg.setGameId(sg.getGameId());
            if (msg.getMessageId() != null) continue;
            msg.setMessageId("msg" + msgIdCounter);
            ++msgIdCounter;
        }
        return sg;
    }

    public class SavedGameExclStrat
    implements ExclusionStrategy {
        @Override
        public boolean shouldSkipClass(Class<?> arg0) {
            return false;
        }

        @Override
        public boolean shouldSkipField(FieldAttributes f) {
            String name = f.getName();
            if (WsReplayableMessage.class.isAssignableFrom(f.getDeclaringClass()) && (name.equals("gameId") || name.equals("messageId"))) {
                return true;
            }
            return AbstractWsMessage.class.isAssignableFrom(f.getDeclaringClass()) && name.equals("sequenceNumber");
        }
    }
}

