/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game.state;

import com.jcloisterzone.board.EdgePattern;
import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.Rotation;
import com.jcloisterzone.board.Tile;
import com.jcloisterzone.feature.Feature;
import java.io.Serializable;
import java.util.function.Function;

public class PlacedTile
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Tile tile;
    private final Position position;
    private final Rotation rotation;

    public PlacedTile(Tile tile, Position position, Rotation rotation) {
        this.tile = tile;
        this.position = position;
        this.rotation = rotation;
    }

    public Tile getTile() {
        return this.tile;
    }

    public Position getPosition() {
        return this.position;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public PlacedTile setTile(Tile tile) {
        return new PlacedTile(tile, this.position, this.rotation);
    }

    public PlacedTile mapTile(Function<Tile, Tile> fn) {
        return new PlacedTile(fn.apply(this.tile), this.position, this.rotation);
    }

    public PlacedTile setPosition(Position position) {
        return new PlacedTile(this.tile, position, this.rotation);
    }

    public PlacedTile setRotation(Rotation rotation) {
        return new PlacedTile(this.tile, this.position, rotation);
    }

    public EdgePattern getEdgePattern() {
        return this.tile.getEdgePattern().rotate(this.rotation);
    }

    public Feature getInitialFeaturePartOf(Location loc) {
        Location initialLoc = loc.rotateCCW(this.getRotation());
        return (Feature)this.tile.getInitialFeatures().find(t -> initialLoc.isPartOf((Location)t._1)).map(t -> (Feature)t._2).getOrNull();
    }

    public String toString() {
        return this.tile + "," + this.position + "," + (Object)((Object)this.rotation);
    }
}

