/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game.state;

import com.jcloisterzone.Player;
import com.jcloisterzone.PlayerScore;
import com.jcloisterzone.figure.Follower;
import com.jcloisterzone.figure.Special;
import com.jcloisterzone.game.Token;
import io.vavr.collection.Array;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import io.vavr.collection.Seq;
import io.vavr.control.Option;
import java.io.Serializable;
import java.util.function.Predicate;

public class PlayersState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Array<Player> players;
    private final Array<PlayerScore> score;
    private final Array<Map<Token, Integer>> tokens;
    private final int turnPlayerIndex;
    private final Array<Seq<Follower>> followers;
    private final Array<Seq<Special>> specialMeeples;

    public static PlayersState createInitial(Array<Player> players, int turnPlayerIndex) {
        return new PlayersState(players, (Array<PlayerScore>)players.map(p -> new PlayerScore()), (Array<Map<Token, Integer>>)players.map(p -> HashMap.empty()), turnPlayerIndex, null, null);
    }

    public PlayersState(Array<Player> players, Array<PlayerScore> score, Array<Map<Token, Integer>> tokens, int turnPlayerIndex, Array<Seq<Follower>> followers, Array<Seq<Special>> specialMeeples) {
        this.players = players;
        this.score = score;
        this.tokens = tokens;
        this.turnPlayerIndex = turnPlayerIndex;
        this.followers = followers;
        this.specialMeeples = specialMeeples;
    }

    public PlayersState setScore(Array<PlayerScore> score) {
        if (this.score == score) {
            return this;
        }
        return new PlayersState(this.players, score, this.tokens, this.turnPlayerIndex, this.followers, this.specialMeeples);
    }

    public PlayersState setTokens(Array<Map<Token, Integer>> tokens) {
        if (this.tokens == tokens) {
            return this;
        }
        return new PlayersState(this.players, this.score, tokens, this.turnPlayerIndex, this.followers, this.specialMeeples);
    }

    public PlayersState setTokenCount(int index, Token token, int count) {
        if (count < 0) {
            throw new IllegalArgumentException(String.format("Token %s count can't be %s", token, count));
        }
        Map<Token, Integer> playerTokens = this.tokens.get(index);
        if (playerTokens.get(token).getOrElse(0) == count) {
            return this;
        }
        if (count == 0) {
            return this.setTokens((Array<Map<Token, Integer>>)this.tokens.update(index, (Object)playerTokens.remove(token)));
        }
        return this.setTokens((Array<Map<Token, Integer>>)this.tokens.update(index, (Object)playerTokens.put(token, count)));
    }

    public PlayersState setTokenCountForAllPlayers(Token token, int count) {
        PlayersState ps = this;
        for (Player p : this.getPlayers()) {
            ps = ps.setTokenCount(p.getIndex(), token, count);
        }
        return ps;
    }

    public PlayersState addTokenCount(int index, Token token, int count) {
        if (count == 0) {
            return this;
        }
        int newValue = this.getPlayerTokenCount(index, token) + count;
        return this.setTokenCount(index, token, newValue);
    }

    public PlayersState setTurnPlayerIndex(int turnPlayerIndex) {
        if (this.turnPlayerIndex == turnPlayerIndex) {
            return this;
        }
        return new PlayersState(this.players, this.score, this.tokens, turnPlayerIndex, this.followers, this.specialMeeples);
    }

    public PlayersState setFollowers(Array<Seq<Follower>> followers) {
        if (this.followers == followers) {
            return this;
        }
        return new PlayersState(this.players, this.score, this.tokens, this.turnPlayerIndex, followers, this.specialMeeples);
    }

    public PlayersState setSpecialMeeples(Array<Seq<Special>> specialMeeples) {
        if (this.specialMeeples == specialMeeples) {
            return this;
        }
        return new PlayersState(this.players, this.score, this.tokens, this.turnPlayerIndex, this.followers, specialMeeples);
    }

    public Array<Player> getPlayers() {
        return this.players;
    }

    public Array<Player> getPlayersBeginWith(Player p) {
        return ((Array)this.players.slice(p.getIndex(), this.players.length())).appendAll((Iterable)this.players.slice(0, p.getIndex()));
    }

    public Player getPlayer(int idx) {
        return this.players.get(idx);
    }

    public int length() {
        return this.players.length();
    }

    public Array<PlayerScore> getScore() {
        return this.score;
    }

    public Array<Map<Token, Integer>> getTokens() {
        return this.tokens;
    }

    public int getPlayerTokenCount(int index, Token token) {
        Map<Token, Integer> playerTokens = this.tokens.get(index);
        return playerTokens.get(token).getOrElse(0);
    }

    public int getTurnPlayerIndex() {
        return this.turnPlayerIndex;
    }

    public Array<Seq<Follower>> getFollowers() {
        return this.followers;
    }

    public Array<Seq<Special>> getSpecialMeeples() {
        return this.specialMeeples;
    }

    public Option<Follower> findFollower(String meepleId) {
        Predicate<Follower> pred = f -> f.getId().equals(meepleId);
        for (Seq seq : this.followers) {
            Option<Follower> res = seq.find(pred);
            if (res.isEmpty()) continue;
            return res;
        }
        return Option.none();
    }

    public Player getTurnPlayer() {
        return this.getPlayer(this.turnPlayerIndex);
    }

    public String toString() {
        return String.join((CharSequence)",", this.players.map(Player::getNick));
    }
}

