/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game.state.mixins;

import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.Rotation;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.feature.Feature;
import com.jcloisterzone.feature.Structure;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.game.state.PlacedTile;
import io.vavr.Predicates;
import io.vavr.Tuple2;
import io.vavr.collection.LinkedHashMap;
import io.vavr.collection.Map;
import io.vavr.collection.Stream;
import java.awt.Rectangle;
import java.util.function.Function;

public interface BoardMixin {
    public LinkedHashMap<Position, PlacedTile> getPlacedTiles();

    public GameState setPlacedTiles(LinkedHashMap<Position, PlacedTile> var1);

    public Map<FeaturePointer, Feature> getFeatureMap();

    public GameState setFeatureMap(Map<FeaturePointer, Feature> var1);

    public GameState mapFeatureMap(Function<Map<FeaturePointer, Feature>, Map<FeaturePointer, Feature>> var1);

    default public PlacedTile getPlacedTile(Position pos) {
        return (PlacedTile)this.getPlacedTiles().get(pos).getOrNull();
    }

    default public PlacedTile getLastPlaced() {
        return (PlacedTile)this.getPlacedTiles().takeRight(1).map(Tuple2::_2).getOrNull();
    }

    default public Stream<Tuple2<Location, PlacedTile>> getAdjacentTiles2(Position pos) {
        return Stream.ofAll(Position.ADJACENT).map(locPos -> locPos.map2(offset -> this.getPlacedTile(pos.add((Position)offset)))).filter(locTile -> locTile._2 != null);
    }

    default public Stream<PlacedTile> getAdjacentTiles(Position pos) {
        return this.getAdjacentTiles2(pos).map(Tuple2::_2);
    }

    default public Stream<Tuple2<Location, PlacedTile>> getAdjacentAndDiagonalTiles2(Position pos) {
        return Stream.ofAll(Position.ADJACENT_AND_DIAGONAL).map(locPos -> locPos.map2(offset -> this.getPlacedTile(pos.add((Position)offset)))).filter(locTile -> locTile._2 != null);
    }

    default public Stream<PlacedTile> getAdjacentAndDiagonalTiles(Position pos) {
        return this.getAdjacentAndDiagonalTiles2(pos).map(Tuple2::_2);
    }

    default public Rectangle getBoardBounds() {
        int minX = 0;
        int maxX = 0;
        int minY = 0;
        int maxY = 0;
        for (Position pos : this.getPlacedTiles().keySet()) {
            if (minX > pos.x) {
                minX = pos.x;
            }
            if (maxX < pos.x) {
                maxX = pos.x;
            }
            if (minY > pos.y) {
                minY = pos.y;
            }
            if (maxY >= pos.y) continue;
            maxY = pos.y;
        }
        return new Rectangle(minX, minY, maxX - minX, maxY - minY);
    }

    default public Stream<Feature> getFeatures() {
        return Stream.ofAll(this.getFeatureMap().values()).distinct();
    }

    default public <T extends Feature> Stream<T> getFeatures(Class<T> cls) {
        return Stream.ofAll(this.getFeatureMap().values()).filter(Predicates.instanceOf(cls)).distinct().map(f -> f);
    }

    default public Stream<Tuple2<Location, Feature>> getTileFeatures2(Position pos) {
        PlacedTile placedTile = this.getPlacedTile(pos);
        Rotation rot = placedTile.getRotation();
        Map<FeaturePointer, Feature> allFeatures = this.getFeatureMap();
        return Stream.ofAll(placedTile.getTile().getInitialFeatures()).map(t -> t.update1(((Location)t._1).rotateCW(rot))).map(t -> t.update2((Feature)allFeatures.get(new FeaturePointer(pos, (Location)t._1)).get()));
    }

    default public <T extends Feature> Stream<Tuple2<Location, T>> getTileFeatures2(Position pos, Class<T> cls) {
        return this.getTileFeatures2(pos).filter(t -> cls.isInstance(t._2)).map(t -> t);
    }

    default public Feature getFeature(FeaturePointer fp) {
        if (fp.getLocation() == Location.MONASTERY) {
            fp = fp.setLocation(Location.CLOISTER);
        }
        return (Feature)this.getFeatureMap().get(fp).getOrNull();
    }

    default public Structure getStructure(FeaturePointer fp) {
        Feature f = this.getFeature(fp);
        return f instanceof Structure ? (Structure)f : null;
    }

    default public Feature getFeaturePartOf(FeaturePointer fp) {
        FeaturePointer normFp = fp.getLocation() == Location.MONASTERY ? fp.setLocation(Location.CLOISTER) : fp;
        return (Feature)this.getFeatureMap().find(t -> normFp.isPartOf((FeaturePointer)t._1)).map(Tuple2::_2).getOrNull();
    }

    default public Structure getStructurePartOf(FeaturePointer fp) {
        Feature f = this.getFeaturePartOf(fp);
        return f instanceof Structure ? (Structure)f : null;
    }

    default public Tuple2<FeaturePointer, Feature> getFeaturePartOf2(FeaturePointer fp) {
        FeaturePointer normFp = fp.getLocation() == Location.MONASTERY ? fp.setLocation(Location.CLOISTER) : fp;
        return (Tuple2)this.getFeatureMap().find(t -> normFp.isPartOf((FeaturePointer)t._1)).getOrNull();
    }
}

