/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.plugin;

import com.jcloisterzone.Expansion;
import com.jcloisterzone.ExpansionType;
import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Rotation;
import com.jcloisterzone.board.Tile;
import com.jcloisterzone.config.Config;
import com.jcloisterzone.feature.Bridge;
import com.jcloisterzone.feature.Castle;
import com.jcloisterzone.feature.City;
import com.jcloisterzone.feature.Cloister;
import com.jcloisterzone.feature.Farm;
import com.jcloisterzone.feature.Feature;
import com.jcloisterzone.feature.River;
import com.jcloisterzone.game.Capability;
import com.jcloisterzone.plugin.Aliases;
import com.jcloisterzone.plugin.NotAPluginException;
import com.jcloisterzone.plugin.PluginAliases;
import com.jcloisterzone.plugin.PluginLoadException;
import com.jcloisterzone.plugin.PluginMeta;
import com.jcloisterzone.ui.ImmutablePoint;
import com.jcloisterzone.ui.UiUtils;
import com.jcloisterzone.ui.resources.FeatureArea;
import com.jcloisterzone.ui.resources.FeatureDescriptor;
import com.jcloisterzone.ui.resources.ImageLoader;
import com.jcloisterzone.ui.resources.LayeredImageDescriptor;
import com.jcloisterzone.ui.resources.ResourceManager;
import com.jcloisterzone.ui.resources.TileImage;
import com.jcloisterzone.ui.resources.svg.ThemeGeometry;
import io.vavr.Tuple2;
import io.vavr.collection.LinearSeq;
import io.vavr.collection.List;
import io.vavr.collection.Stream;
import io.vavr.collection.Vector;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.YAMLException;

public class Plugin
implements ResourceManager {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Config config;
    private final Path path;
    private final Path relPath;
    private final ImageLoader imageLoader;
    private final URLClassLoader loader;
    private PluginMeta meta;
    private Vector<String> includedClasses;
    private boolean loaded;
    private boolean enabled;
    private PluginAliases aliases;
    private ResourceManager parentResourceManager;
    private ThemeGeometry pluginGeometry;
    private Insets imageOffset = new Insets(0, 0, 0, 0);
    private int imageRatioX = 1;
    private int imageRatioY = 1;
    private HashMap<Tuple2<Tile, Rotation>, io.vavr.collection.Map<Location, FeatureArea>> areaCache = new HashMap();
    private Vector<Expansion> expansionsToRegister = Vector.empty();
    private Set<String> supportedExpansions = null;

    public static Plugin readPlugin(Config config, Path relPath, Path path) throws NotAPluginException, PluginLoadException {
        Plugin plugin = new Plugin(config, relPath, path);
        plugin.loadMetadata();
        return plugin;
    }

    public Plugin(Config config, Path relPath, Path path) throws PluginLoadException {
        this.config = config;
        this.relPath = relPath;
        this.path = path;
        URL url = this.getFixedURL();
        this.logger.debug("Creating plugin loader for {}", (Object)url);
        this.loader = new URLClassLoader(new URL[]{url});
        this.imageLoader = new ImageLoader(this.loader);
    }

    private URL getFixedURL() throws PluginLoadException {
        try {
            URL url = this.path.toUri().toURL();
            if (Files.isRegularFile(this.path, new LinkOption[0]) || url.toString().endsWith("/")) {
                return url;
            }
            return new URL(url.toString() + "/");
        }
        catch (MalformedURLException e) {
            throw new PluginLoadException(e);
        }
    }

    protected void loadMetadata() throws NotAPluginException, PluginLoadException {
        Yaml yaml = new Yaml(new Constructor(PluginMeta.class));
        URL pluginYaml = this.loader.getResource("plugin.yaml");
        if (pluginYaml == null) {
            throw new NotAPluginException(String.format("%s is not a plugin", this.path));
        }
        try {
            this.meta = (PluginMeta)yaml.load(pluginYaml.openStream());
        }
        catch (IOException | YAMLException e) {
            throw new PluginLoadException(e);
        }
        this.includedClasses = Vector.empty();
        try {
            Files.walk(this.path, new FileVisitOption[0]).filter(f -> f.toString().endsWith(".class")).forEach(f -> {
                String clsName = this.path.relativize((Path)f).toString().replace(File.separator, ".").replaceAll("\\.class$", "");
                this.includedClasses = this.includedClasses.append((Object)clsName);
            });
        }
        catch (IOException e) {
            throw new PluginLoadException(e);
        }
        if (this.meta.getExpansions() != null) {
            for (PluginMeta.ExpansionMeta expMeta : this.meta.getExpansions()) {
                ExpansionType type = ExpansionType.valueOf(expMeta.getType());
                ArrayList capabilityClasses = new ArrayList();
                if (expMeta.getCapabilities() != null) {
                    for (String name : expMeta.getCapabilities()) {
                        try {
                            Class<Capability<?>> cls = Capability.classForName(name, this.loader);
                            capabilityClasses.add(cls);
                        }
                        catch (ClassNotFoundException e) {
                            throw new PluginLoadException(e);
                        }
                    }
                }
                Class[] _capabilityClasses = capabilityClasses.toArray(new Class[capabilityClasses.size()]);
                Expansion exp = new Expansion(expMeta.getName(), expMeta.getCode(), this.getLocalizedString(expMeta.getLabel(), expMeta.getLabel_i18n()), _capabilityClasses, type);
                this.expansionsToRegister = this.expansionsToRegister.append((Object)exp);
            }
        }
        if (!Files.isDirectory(this.path, new LinkOption[0])) {
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("create", "true");
            try {
                FileSystems.newFileSystem(this.getLoader().getResource("tiles").toURI(), env);
            }
            catch (IOException | URISyntaxException e) {
                throw new PluginLoadException(e);
            }
        }
        try {
            this.supportedExpansions = Files.list(Paths.get(this.getLoader().getResource("tiles").toURI())).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(d -> d.getFileName().toString().replaceAll("/$", "")).collect(Collectors.toSet());
        }
        catch (IOException | URISyntaxException e) {
            throw new PluginLoadException(e);
        }
        if (this.meta.getTile_images() != null) {
            Integer intValue;
            String value = this.meta.getTile_images().getOffset();
            if (value != null) {
                String[] tokens = value.split(",");
                if (tokens.length != 4) {
                    throw new PluginLoadException("Invalid value for image-offset " + value);
                }
                this.imageOffset = new Insets(Integer.parseInt(tokens[0]), Integer.parseInt(tokens[1]), Integer.parseInt(tokens[2]), Integer.parseInt(tokens[3]));
            }
            if ((intValue = this.getMetadata().getTile_images().getRatio_x()) != null) {
                this.imageRatioX = intValue;
                if (this.imageRatioX == 0) {
                    this.imageRatioX = 1;
                }
            }
            if ((intValue = this.getMetadata().getTile_images().getRatio_y()) != null) {
                this.imageRatioY = intValue;
                if (this.imageRatioY == 0) {
                    this.imageRatioY = 1;
                }
            }
        }
    }

    public String getLocalizedString(String defaultValue, Map<String, String> trans) {
        if (trans == null) {
            return defaultValue;
        }
        String lang = this.config.getLocaleObject().getLanguage();
        String value = trans.get(lang);
        return value == null ? defaultValue : value;
    }

    public Image getIcon() {
        return this.imageLoader.getImage("icon");
    }

    public Path getPath() {
        return this.path;
    }

    public Path getRelativePath() {
        return this.relPath;
    }

    public PluginMeta getMetadata() {
        return this.meta;
    }

    public String getTitle() {
        return this.getLocalizedString(this.meta.getTitle(), this.meta.getTitle_i18n());
    }

    public String getDescription() {
        return this.getLocalizedString(this.meta.getDescription(), this.meta.getDescription_i18n());
    }

    public boolean isDefault() {
        String fileName = this.path.getFileName().toString().trim();
        return fileName.endsWith("classic.jar") || fileName.endsWith("classic");
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public URLClassLoader getLoader() {
        return this.loader;
    }

    public ImageLoader getImageLoader() {
        return this.imageLoader;
    }

    public String toString() {
        return this.meta.getTitle();
    }

    public final void load() throws PluginLoadException {
        if (!this.isLoaded()) {
            this.doLoad();
            this.loaded = true;
        }
    }

    @Override
    public void reload() {
    }

    public final void unload() {
        if (this.isLoaded()) {
            this.doUnload();
            this.loaded = false;
        }
    }

    protected void doLoad() throws PluginLoadException {
        this.includedClasses.forEach(clsName -> {
            try {
                Class<?> c = this.loader.loadClass((String)clsName);
                this.logger.debug("External class {} has been loaded.", (Object)c.getName());
            }
            catch (ClassNotFoundException e) {
                this.logger.error(e.getMessage(), e);
            }
        });
        for (Expansion exp : this.expansionsToRegister) {
            Expansion.register(exp, this);
        }
        try {
            this.aliases = new PluginAliases(this.getLoader(), "tiles");
            this.pluginGeometry = new ThemeGeometry(this.getLoader(), "tiles", this.getImageSizeRatio());
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new PluginLoadException(e);
        }
    }

    protected void doUnload() {
        for (Expansion exp : this.expansionsToRegister) {
            Expansion.unregister(exp);
        }
    }

    public boolean isExpansionSupported(Expansion exp) {
        return this.supportedExpansions.contains(exp.getCode());
    }

    public Set<String> getContainedExpansions() {
        return this.supportedExpansions;
    }

    public double getImageSizeRatio() {
        return (double)this.imageRatioY / (double)this.imageRatioX;
    }

    private boolean isTileSupported(String tileId) {
        return this.supportedExpansions.contains(tileId.split("\\.", 2)[0]);
    }

    @Override
    public TileImage getTileImage(String tileId, Rotation rot) {
        if (!this.isEnabled()) {
            return null;
        }
        String aliasId = this.aliases.getImageAlias(tileId);
        if (aliasId != null) {
            if (!this.isTileSupported(aliasId)) {
                return this.parentResourceManager.getTileImage(aliasId, rot);
            }
            tileId = aliasId;
        } else if (!this.isTileSupported(tileId)) {
            return null;
        }
        String[] tokens = tileId.split("\\.", 2);
        String baseName = String.format("tiles/%s/%s", tokens[0], tokens[1]);
        String fileName = baseName + "@" + rot.ordinal();
        Image img = this.getImageLoader().getImage(fileName);
        if (img != null) {
            return new TileImage(img, this.imageOffset);
        }
        fileName = baseName;
        img = this.getImageLoader().getImage(fileName);
        if (img == null) {
            return null;
        }
        if (rot == Rotation.R0) {
            return new TileImage(img, this.imageOffset);
        }
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        BufferedImage buf = rot == Rotation.R180 ? UiUtils.newTransparentImage(w, h) : UiUtils.newTransparentImage(h, w);
        Graphics2D g = (Graphics2D)buf.getGraphics();
        g.drawImage(img, rot.getAffineTransform(w, h), null);
        return new TileImage(buf, this.imageOffset);
    }

    @Override
    public Image getImage(String path) {
        return this.getImageLoader().getImage(path);
    }

    @Override
    public Image getLayeredImage(LayeredImageDescriptor lid) {
        return this.getImageLoader().getLayeredImage(lid);
    }

    @Override
    public ImmutablePoint getMeeplePlacement(String effectiveTileId, Tile tile, Rotation rot, Location loc) {
        if (!this.isEnabled()) {
            return null;
        }
        String aliasId = this.aliases.getGeometryAlias(effectiveTileId);
        if (aliasId != null) {
            if (!this.isTileSupported(aliasId)) {
                return this.parentResourceManager.getMeeplePlacement(aliasId, tile, rot, loc);
            }
            effectiveTileId = aliasId;
        } else if (!this.isTileSupported(effectiveTileId)) {
            return null;
        }
        if (loc == Location.MONASTERY) {
            loc = Location.CLOISTER;
        }
        Location iniLoc = loc.rotateCCW(rot);
        Feature feature = tile.getInitialFeatures().get(iniLoc).get();
        Class<?> featureClass = feature.getClass();
        ImmutablePoint point = this.pluginGeometry.getMeeplePlacement(effectiveTileId, featureClass, iniLoc);
        if (point == null) {
            point = ThemeGeometry.DEFAULT_GEOMETRY.getMeeplePlacement(effectiveTileId, featureClass, iniLoc);
        }
        if (point == null) {
            this.logger.warn("No point defined for <" + new FeatureDescriptor(tile.getId(), featureClass, loc) + ">");
            point = ImmutablePoint.ZERO;
        }
        return point.rotate100(rot);
    }

    @Override
    public ImmutablePoint getBarnPlacement() {
        return null;
    }

    private FeatureArea getFeatureArea(String tileId, Class<? extends Feature> featureClass, Location loc) {
        boolean monasteryShading = false;
        if (loc == Location.MONASTERY) {
            loc = Location.CLOISTER;
            monasteryShading = true;
        }
        if (Castle.class.equals(featureClass)) {
            featureClass = City.class;
        }
        ThemeGeometry source = null;
        FeatureArea area = this.pluginGeometry.getArea(tileId, featureClass, loc);
        if (area == null) {
            area = this.adaptDefaultGeometry(ThemeGeometry.DEFAULT_GEOMETRY.getArea(tileId, featureClass, loc));
            if (area == null) {
                this.logger.error("No shape defined for <" + new FeatureDescriptor(tileId, featureClass, loc) + ">");
                return new FeatureArea(new Area(), 0);
            }
            source = ThemeGeometry.DEFAULT_GEOMETRY;
        } else {
            source = this.pluginGeometry;
        }
        if (monasteryShading) {
            area = area.setZIndex(area.getzIndex() - 1);
        }
        return area;
    }

    private Area getSubtractionArea(String tileId, boolean farm) {
        Area d = ThemeGeometry.DEFAULT_GEOMETRY.getSubtractionArea(tileId, farm);
        Area p = this.pluginGeometry.getSubtractionArea(tileId, farm);
        Area area = new Area();
        if (d != null) {
            area.add(this.adaptDefaultGeometry(d));
        }
        if (p != null) {
            area.add(p);
        }
        return area;
    }

    private boolean isFarmComplement(String tileId, Location loc) {
        Boolean value = this.pluginGeometry.isFarmComplement(tileId, loc);
        if (value != null) {
            return value;
        }
        value = ThemeGeometry.DEFAULT_GEOMETRY.isFarmComplement(tileId, loc);
        if (value != null) {
            return value;
        }
        return false;
    }

    private FeatureArea adaptDefaultGeometry(FeatureArea fa) {
        if (fa == null) {
            return null;
        }
        return fa.transform(AffineTransform.getScaleInstance(1.0, this.getImageSizeRatio()));
    }

    private Area adaptDefaultGeometry(Area a) {
        if (a == null) {
            return null;
        }
        if (this.imageRatioX != this.imageRatioY) {
            return a.createTransformedArea(AffineTransform.getScaleInstance(1.0, this.getImageSizeRatio()));
        }
        return a;
    }

    @Override
    public FeatureArea getFeatureArea(String effectiveTileId, Tile tile, Rotation rot, Location loc) {
        if (!this.isEnabled()) {
            return null;
        }
        Tuple2<Tile, Rotation> key = new Tuple2<Tile, Rotation>(tile, rot);
        io.vavr.collection.Map<Location, FeatureArea> areas = this.areaCache.get(key);
        if (areas == null) {
            String aliasId = this.aliases.getGeometryAlias(effectiveTileId);
            if (aliasId != null) {
                if (!this.isTileSupported(aliasId)) {
                    return this.parentResourceManager.getFeatureArea(aliasId, tile, rot, loc);
                }
                effectiveTileId = aliasId;
            } else if (!this.isTileSupported(tile.getId())) {
                return null;
            }
            areas = this.getTileFeatureAreas(tile, rot, effectiveTileId);
            this.areaCache.put(key, areas);
        }
        return (FeatureArea)areas.get(loc).getOrNull();
    }

    private io.vavr.collection.Map<Location, FeatureArea> getTileFeatureAreas(Tile tile, Rotation rot, String effectiveTileId) {
        io.vavr.collection.Map<Location, Feature> features = tile.getInitialFeatures();
        Location complementFarm = (Location)features.find(t -> t._2 instanceof Farm && this.isFarmComplement(effectiveTileId, (Location)t._1)).map(Tuple2::_1).getOrNull();
        Location bridgeLoc = (Location)features.find(t -> t._2 instanceof Bridge).map(Tuple2::_1).getOrNull();
        AffineTransform txRot = rot.getAffineTransform(1000);
        Area onlyFarmSubtraction = this.getSubtractionArea(effectiveTileId, true);
        Area allSubtraction = this.getSubtractionArea(effectiveTileId, false);
        onlyFarmSubtraction.transform(txRot);
        allSubtraction.transform(txRot);
        io.vavr.collection.Map<Location, FeatureArea> baseAreas = Stream.ofAll(features).filter(t -> !(t._2 instanceof River)).filter(t -> t._1 != complementFarm).flatMap(t -> {
            if (t._2 instanceof Cloister && ((Cloister)t._2).isMonastery()) {
                return List.of(t, t.update1(Location.MONASTERY));
            }
            return List.of(t);
        }).toMap(t -> {
            Location loc = (Location)t._1;
            Feature feature = (Feature)t._2;
            FeatureArea fa = bridgeLoc == loc ? this.getBridgeArea(loc.rotateCCW(rot)) : this.getFeatureArea(effectiveTileId, feature.getClass(), loc);
            if (!fa.isFixed()) {
                fa = fa.transform(txRot);
            }
            return new Tuple2<Location, FeatureArea>(loc, fa);
        });
        FeatureArea towerArea = (FeatureArea)baseAreas.get(Location.TOWER).getOrNull();
        Area nonFarmUnion = baseAreas.foldLeft(new Area(), (area, t) -> {
            if (!((Location)t._1).isFarmLocation()) {
                area.add(((FeatureArea)t._2).getTrackingArea());
            }
            return area;
        });
        if (complementFarm != null) {
            Area union = baseAreas.foldLeft(new Area(), (area, t) -> {
                area.add(((FeatureArea)t._2).getTrackingArea());
                return area;
            });
            Area farmArea = new Area(this.getFullRectangle());
            farmArea.subtract(union);
            baseAreas = baseAreas.put(complementFarm, new FeatureArea(farmArea, 10));
        }
        LinearSeq areas = Stream.ofAll(baseAreas).map(t -> {
            if (!((Location)t._1).isFarmLocation()) {
                return t;
            }
            return t.map2(fa -> fa.subtract(nonFarmUnion));
        }).map(t -> {
            Location loc = (Location)t._1;
            if (loc == bridgeLoc) {
                return t;
            }
            if (loc.isFarmLocation()) {
                t = t.map2(fa -> fa.subtract(onlyFarmSubtraction));
            }
            return t.map2(fa -> fa.subtract(allSubtraction));
        });
        if (towerArea != null) {
            areas = areas.map(t -> {
                Location loc = (Location)t._1;
                if (loc == bridgeLoc || loc == Location.TOWER) {
                    return t;
                }
                return t.map2(fa -> fa.subtract(towerArea));
            });
        }
        if (bridgeLoc != null) {
            FeatureArea bridgeArea = (FeatureArea)baseAreas.get(bridgeLoc).get();
            areas = areas.map(t -> {
                if (t._1 == bridgeLoc || ((Location)t._1).isFarmLocation()) {
                    return t;
                }
                return t.map2(fa -> fa.subtract(bridgeArea));
            });
        }
        return areas.toMap(t -> t.map1(loc -> loc.rotateCW(rot)));
    }

    @Override
    public FeatureArea getBarnArea() {
        return null;
    }

    @Override
    public FeatureArea getBridgeArea(Location loc) {
        Area a = this.pluginGeometry.getBridgeArea(loc);
        return new FeatureArea(a, 50).setFixed(true);
    }

    private Rectangle getFullRectangle() {
        return new Rectangle(0, 0, 999, (int)(1000.0 * this.getImageSizeRatio()));
    }

    public Aliases getAliases() {
        return this.aliases;
    }

    public ResourceManager getParentResourceManager() {
        return this.parentResourceManager;
    }

    public void setParentResourceManager(ResourceManager parentResourceManager) {
        this.parentResourceManager = parentResourceManager;
    }
}

