/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.plugin;

import com.jcloisterzone.XMLUtils;
import com.jcloisterzone.plugin.Aliases;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PluginAliases
implements Aliases {
    private final Map<String, String> geometryAliases = new HashMap<String, String>();
    private final Map<String, String> imageAliases = new HashMap<String, String>();

    public PluginAliases(ClassLoader loader, String folder) throws IOException, SAXException, ParserConfigurationException {
        URL aliasesResource = loader.getResource(folder + "/aliases.xml");
        if (aliasesResource != null) {
            Element aliasesEl = XMLUtils.parseDocument(aliasesResource).getDocumentElement();
            NodeList nl = aliasesEl.getElementsByTagName("alias");
            for (int i = 0; i < nl.getLength(); ++i) {
                Element alias = (Element)nl.item(i);
                String forTile = alias.getAttribute("for");
                String useAll = alias.getAttribute("use");
                String useGeometry = alias.getAttribute("useGeometry");
                String useImage = alias.getAttribute("useImage");
                if (useGeometry.isEmpty()) {
                    useGeometry = useAll;
                }
                if (useImage.isEmpty()) {
                    useImage = useAll;
                }
                if (!useGeometry.isEmpty()) {
                    this.geometryAliases.put(forTile, useGeometry);
                }
                if (useImage.isEmpty()) continue;
                this.imageAliases.put(forTile, useImage);
            }
        }
    }

    @Override
    public String getImageAlias(String tileId) {
        return this.imageAliases.get(tileId);
    }

    @Override
    public String getGeometryAlias(String tileId) {
        return this.geometryAliases.get(tileId);
    }
}

