/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.reducers;

import com.jcloisterzone.Player;
import com.jcloisterzone.PlayerScore;
import com.jcloisterzone.PointCategory;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.reducers.Reducer;
import io.vavr.collection.Array;
import io.vavr.collection.IndexedSeq;

public class AddPoints
implements Reducer {
    final Player player;
    final int points;
    final PointCategory category;

    public AddPoints(Player player, int points, PointCategory category) {
        this.player = player;
        this.points = points;
        this.category = category;
    }

    @Override
    public GameState apply(GameState state) {
        if (this.points == 0) {
            return state;
        }
        int idx = this.player.getIndex();
        return state.mapPlayers(ps -> {
            IndexedSeq<PlayerScore> score = ps.getScore();
            PlayerScore playerScore = score.get(idx);
            score = score.update(idx, (Object)playerScore.addPoints(this.points, this.category));
            return ps.setScore((Array<PlayerScore>)score);
        });
    }
}

