/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.reducers;

import com.jcloisterzone.Player;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.event.play.FollowerCaptured;
import com.jcloisterzone.event.play.PlayEvent;
import com.jcloisterzone.figure.Follower;
import com.jcloisterzone.figure.Meeple;
import com.jcloisterzone.game.capability.TowerCapability;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.reducers.UndeployMeeple;
import io.vavr.collection.LinkedHashMap;

public class CaptureMeeple
extends UndeployMeeple {
    public CaptureMeeple(Follower follower) {
        super(follower, true);
    }

    @Override
    protected GameState primaryUndeploy(GameState state, PlayEvent.PlayEventMeta meta, Meeple meeple, FeaturePointer source) {
        Follower follower = (Follower)meeple;
        Player p = state.getPlayers().getPlayer(meta.getTriggeringPlayerIndex());
        if (p.equals(follower.getPlayer())) {
            return super.primaryUndeploy(state, meta, follower, source);
        }
        LinkedHashMap<Meeple, FeaturePointer> deployedMeeples = state.getDeployedMeeples();
        state = state.setDeployedMeeples((LinkedHashMap<Meeple, FeaturePointer>)deployedMeeples.remove((Object)follower));
        state = state.mapCapabilityModel(TowerCapability.class, model -> model.update(p.getIndex(), l -> l.append(follower)));
        state = state.appendEvent(new FollowerCaptured(meta, follower, source));
        return state;
    }
}

