/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.reducers;

import com.jcloisterzone.board.Edge;
import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.Rotation;
import com.jcloisterzone.board.ShortEdge;
import com.jcloisterzone.board.Tile;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.event.play.PlayEvent;
import com.jcloisterzone.event.play.TilePlacedEvent;
import com.jcloisterzone.feature.City;
import com.jcloisterzone.feature.Cloister;
import com.jcloisterzone.feature.Completable;
import com.jcloisterzone.feature.CompletableFeature;
import com.jcloisterzone.feature.Feature;
import com.jcloisterzone.feature.MultiTileFeature;
import com.jcloisterzone.feature.Road;
import com.jcloisterzone.game.Capability;
import com.jcloisterzone.game.capability.AbbeyCapability;
import com.jcloisterzone.game.capability.TunnelCapability;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.game.state.PlacedTile;
import com.jcloisterzone.reducers.Reducer;
import io.vavr.Function3;
import io.vavr.Tuple2;
import io.vavr.Tuple3;
import io.vavr.collection.HashMap;
import io.vavr.collection.LinkedHashMap;
import io.vavr.collection.Map;
import io.vavr.collection.Set;
import io.vavr.collection.Stream;
import io.vavr.collection.Traversable;
import java.util.ArrayList;
import java.util.HashSet;

public class PlaceTile
implements Reducer {
    private final Tile tile;
    private final Position pos;
    private final Rotation rot;

    public PlaceTile(Tile tile, Position pos, Rotation rot) {
        this.tile = tile;
        this.pos = pos;
        this.rot = rot;
    }

    @Override
    public GameState apply(GameState state) {
        LinkedHashMap<Position, PlacedTile> placedTiles = state.getPlacedTiles();
        assert (!placedTiles.containsKey(this.pos));
        boolean abbeyPlacement = AbbeyCapability.isAbbey(this.tile);
        PlacedTile placedTile = new PlacedTile(this.tile, this.pos, this.rot);
        GameState _state = state = state.setPlacedTiles((LinkedHashMap<Position, PlacedTile>)placedTiles.put((Object)this.pos, (Object)placedTile));
        java.util.HashMap<FeaturePointer, Feature> fpUpdate = new java.util.HashMap<FeaturePointer, Feature>();
        HashSet newTunnels = new HashSet();
        ArrayList multiEdgePairsToMerge = new ArrayList();
        Stream.ofAll(this.tile.getInitialFeatures().values()).map(f -> f.placeOnBoard(this.pos, this.rot)).forEach(feature -> {
            if (feature instanceof Road) {
                Road road = (Road)feature;
                newTunnels.addAll(road.getOpenTunnelEnds().toJavaSet());
            }
            if (feature instanceof MultiTileFeature) {
                HashSet alreadyMerged = new HashSet();
                HashSet mergedEdges = new HashSet();
                Function3<MultiTileFeature, FeaturePointer, MultiTileFeature, MultiTileFeature> merge = (f, fullFp, adj) -> {
                    MultiTileFeature updatedAdj = adj;
                    if (fpUpdate.containsKey(fullFp)) {
                        updatedAdj = (MultiTileFeature)fpUpdate.get(fullFp);
                    }
                    alreadyMerged.add(adj);
                    return f.merge(updatedAdj);
                };
                Stream<FeaturePointer> adjacent = ((FeaturePointer)feature.getPlaces().get()).getAdjacent(feature.getClass());
                if ((feature = (Feature)adjacent.foldLeft((MultiTileFeature)feature, (f, adjFp) -> {
                    MultiTileFeature adj;
                    Tuple2<FeaturePointer, Feature> adjTuple = _state.getFeaturePartOf2((FeaturePointer)adjFp);
                    MultiTileFeature multiTileFeature = adj = adjTuple == null ? null : (MultiTileFeature)adjTuple._2;
                    if (adj != null) {
                        if (!alreadyMerged.contains(adj)) {
                            f = (MultiTileFeature)merge.apply((MultiTileFeature)f, (FeaturePointer)adjTuple._1, adj);
                        }
                        if (f instanceof City) {
                            Edge edge = new Edge(this.pos, adjFp.getPosition());
                            mergedEdges.add(edge);
                        }
                    }
                    return f;
                })) instanceof City) {
                    City city = (City)feature;
                    Set<Edge> openEdges = city.getOpenEdges();
                    Traversable mutliEdgeToMerge = city.getMultiEdges().filter(e -> mergedEdges.contains(((ShortEdge)e._1).toEdge()));
                    if (mutliEdgeToMerge.nonEmpty()) {
                        for (Tuple2 multiEdge : mutliEdgeToMerge) {
                            FeaturePointer fullFp2 = (FeaturePointer)multiEdge._2;
                            City adj2 = (City)_state.getFeature(fullFp2);
                            multiEdgePairsToMerge.add(new Tuple3<FeaturePointer, FeaturePointer, ShortEdge>(fullFp2, feature.getPlaces().find(fp -> fp.getPosition().equals(this.pos)).get(), (ShortEdge)multiEdge._1));
                            if (fpUpdate.containsKey(fullFp2)) continue;
                            fpUpdate.put(fullFp2, adj2);
                        }
                        feature = city;
                    }
                }
            }
            this.updateRefs((java.util.Map<FeaturePointer, Feature>)fpUpdate, (Feature)feature);
        });
        for (Tuple3 tuple3 : multiEdgePairsToMerge) {
            Object c2;
            City c1 = (City)fpUpdate.get(tuple3._1);
            CompletableFeature c = c1 == (c2 = (City)fpUpdate.get(tuple3._2)) ? c1 : c1.merge((City)c2);
            c = c.setOpenEdges((Set)c.getOpenEdges().remove((Edge)tuple3._3));
            this.updateRefs(fpUpdate, c);
        }
        if (abbeyPlacement) {
            java.util.HashMap<CompletableFeature, Completable> featureReplacement = new java.util.HashMap<CompletableFeature, Completable>();
            FeaturePointer featurePointer = new FeaturePointer(this.pos, Location.CLOISTER);
            Set<Object> abbeyNeighboring = io.vavr.collection.HashSet.empty();
            for (Location side : Location.SIDES) {
                FeaturePointer adjPartOfPtr = new FeaturePointer(this.pos.add(side), side.rev());
                CompletableFeature originalAdj = (CompletableFeature)state.getFeaturePartOf(adjPartOfPtr);
                if (originalAdj == null) continue;
                Completable adj = featureReplacement.getOrDefault(originalAdj, originalAdj);
                FeaturePointer adjPtr = adj.getPlaces().find(fp -> adjPartOfPtr.isPartOf((FeaturePointer)fp)).get();
                adj = adj.mergeAbbeyEdge(new Edge(this.pos, side));
                if ((adj = adj.setNeighboring((Set)adj.getNeighboring().add(featurePointer))) instanceof City) {
                    ShortEdge edge = new ShortEdge(this.pos, side);
                    City city = (City)adj;
                    Tuple2 multiEdge = (Tuple2)city.getMultiEdges().find(me -> ((ShortEdge)me._1).equals(edge)).getOrNull();
                    if (multiEdge != null) {
                        FeaturePointer multiEdgeFp = (FeaturePointer)multiEdge._2;
                        City originalCity2 = (City)state.getFeaturePartOf(multiEdgeFp);
                        CompletableFeature city2 = featureReplacement.getOrDefault(originalCity2, originalCity2);
                        if (originalAdj == originalCity2) {
                            adj = adj.setOpenEdges(adj.getOpenEdges().remove((Edge)multiEdge._1));
                        } else {
                            city2 = ((City)city2).setOpenEdges((Set)city2.getOpenEdges().remove((Edge)multiEdge._1));
                            city2 = ((City)city2).setNeighboring((Set)city2.getNeighboring().add(featurePointer));
                            featureReplacement.put(originalCity2, city2);
                            this.updateRefs(fpUpdate, city2);
                            abbeyNeighboring = abbeyNeighboring.add(multiEdgeFp);
                        }
                    }
                }
                featureReplacement.put(originalAdj, adj);
                this.updateRefs(fpUpdate, adj);
                abbeyNeighboring = abbeyNeighboring.add(adjPtr);
            }
            if (!abbeyNeighboring.isEmpty()) {
                Cloister abbey = (Cloister)fpUpdate.get(featurePointer);
                fpUpdate.put(featurePointer, abbey.setNeighboring(abbeyNeighboring));
            }
        }
        if (!newTunnels.isEmpty()) {
            state = state.mapCapabilityModel(TunnelCapability.class, model -> {
                Map newTunnelsMap = io.vavr.collection.HashSet.ofAll(newTunnels).toMap(fp -> new Tuple2<FeaturePointer, Object>((FeaturePointer)fp, null));
                return model.merge(newTunnelsMap);
            });
        }
        state = state.mapFeatureMap(m -> HashMap.ofAll(fpUpdate).merge((Map)m));
        state = state.appendEvent(new TilePlacedEvent(PlayEvent.PlayEventMeta.createWithActivePlayer(state), this.tile, this.pos, this.rot));
        for (Capability capability : state.getCapabilities().toSeq()) {
            state = capability.onTilePlaced(state, placedTile);
        }
        return state;
    }

    private void updateRefs(java.util.Map<FeaturePointer, Feature> fpUpdate, Feature f) {
        for (FeaturePointer fp : f.getPlaces()) {
            fpUpdate.put(fp, f);
        }
    }
}

