/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.reducers;

import com.jcloisterzone.Player;
import com.jcloisterzone.feature.Completable;
import com.jcloisterzone.figure.neutral.Mage;
import com.jcloisterzone.figure.neutral.Witch;
import com.jcloisterzone.game.ScoreFeatureReducer;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.reducers.ReturnNeutralFigure;
import com.jcloisterzone.reducers.ScoreFeature;

public class ScoreCompletable
extends ScoreFeature
implements ScoreFeatureReducer {
    private int points;

    public ScoreCompletable(Completable feature, boolean isFinal) {
        super(feature, isFinal);
    }

    @Override
    protected int getFeaturePoints(GameState state, Player player) {
        return this.points;
    }

    @Override
    public int getFeaturePoints() {
        return this.points;
    }

    @Override
    public Completable getFeature() {
        return (Completable)super.getFeature();
    }

    @Override
    public GameState apply(GameState state) {
        this.points = this.getFeature().getPoints(state);
        state = super.apply(state);
        if (!this.isFinal) {
            Witch witch;
            Mage mage = state.getNeutralFigures().getMage();
            if (mage != null && mage.getFeature(state) == this.getFeature()) {
                state = new ReturnNeutralFigure(mage).apply(state);
            }
            if ((witch = state.getNeutralFigures().getWitch()) != null && witch.getFeature(state) == this.getFeature()) {
                state = new ReturnNeutralFigure(witch).apply(state);
            }
        }
        return state;
    }
}

