/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.reducers;

import com.jcloisterzone.Player;
import com.jcloisterzone.PointCategory;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.event.play.ScoreEvent;
import com.jcloisterzone.feature.Farm;
import com.jcloisterzone.feature.Scoreable;
import com.jcloisterzone.figure.Barn;
import com.jcloisterzone.game.ScoreFeatureReducer;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.reducers.AddPoints;
import io.vavr.Tuple2;
import io.vavr.collection.HashMap;
import io.vavr.collection.LinearSeq;
import io.vavr.collection.Map;
import io.vavr.collection.Set;

public class ScoreFarmBarn
implements ScoreFeatureReducer {
    private final Farm farm;
    private final boolean isFinal;
    private Map<Player, Integer> playerPoints = HashMap.empty();

    public ScoreFarmBarn(Farm farm, boolean isFinal) {
        this.farm = farm;
        this.isFinal = isFinal;
    }

    @Override
    public Scoreable getFeature() {
        return this.farm;
    }

    @Override
    public GameState apply(GameState state) {
        LinearSeq barns = this.farm.getSpecialMeeples2(state).filter(t -> t._1 instanceof Barn);
        int points = this.farm.getBarnPoints(state);
        PointCategory pointCategory = this.farm.getPointCategory();
        for (Tuple2 t2 : barns) {
            Barn barn = (Barn)t2._1;
            state = new AddPoints(barn.getPlayer(), points, pointCategory).apply(state);
            this.playerPoints = this.playerPoints.put(barn.getPlayer(), points);
            ScoreEvent scoreEvent = new ScoreEvent(points, pointCategory, this.isFinal, (FeaturePointer)t2._2, barn);
            state = state.appendEvent(scoreEvent);
        }
        return state;
    }

    @Override
    public Set<Player> getOwners() {
        return this.playerPoints.keySet();
    }

    @Override
    public int getFeaturePoints() {
        throw new UnsupportedOperationException("Call getFeaturePoints() with player argument");
    }

    @Override
    public int getFeaturePoints(Player player) {
        return this.playerPoints.getOrElse(player, 0);
    }
}

