/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.reducers;

import com.jcloisterzone.Player;
import com.jcloisterzone.PointCategory;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.event.play.ScoreEvent;
import com.jcloisterzone.feature.Scoreable;
import com.jcloisterzone.figure.Follower;
import com.jcloisterzone.figure.Meeple;
import com.jcloisterzone.game.BonusPoints;
import com.jcloisterzone.game.Capability;
import com.jcloisterzone.game.ScoreFeatureReducer;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.reducers.AddPoints;
import io.vavr.Tuple2;
import io.vavr.collection.HashMap;
import io.vavr.collection.LinearSeq;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.collection.Set;
import java.util.Objects;

public abstract class ScoreFeature
implements ScoreFeatureReducer {
    private final Scoreable feature;
    protected final boolean isFinal;
    private Set<Player> owners;

    public ScoreFeature(Scoreable feature, boolean isFinal) {
        this.feature = feature;
        this.isFinal = isFinal;
    }

    protected abstract int getFeaturePoints(GameState var1, Player var2);

    @Override
    public GameState apply(GameState state) {
        List<ScoreEventSource> sources;
        PointCategory pointCategory = this.feature.getPointCategory();
        this.owners = this.feature.getOwners(state);
        List<BonusPoints> bonusPoints = List.empty();
        for (Capability capability : state.getCapabilities().toSeq()) {
            bonusPoints = capability.appendBonusPoints(state, bonusPoints, this.feature, this.isFinal);
        }
        Map<Object, Object> playerPoints = HashMap.empty();
        if (this.owners.isEmpty()) {
            for (Player player : this.feature.getFollowers(state).map(Meeple::getPlayer).distinct()) {
                playerPoints = playerPoints.put(player, List.of(new ScoreEventSource(0, null, null)));
            }
        } else {
            for (Player player : this.owners) {
                int points = this.getFeaturePoints(state, player);
                state = new AddPoints(player, points, pointCategory).apply(state);
                playerPoints = playerPoints.put(player, List.of(new ScoreEventSource(points, null, null)));
            }
        }
        for (BonusPoints bonusPoints2 : bonusPoints) {
            Player player = bonusPoints2.getPlayer();
            state = new AddPoints(player, bonusPoints2.getPoints(), bonusPoints2.getPointCategory()).apply(state);
            sources = playerPoints.get(player).getOrElse(List.empty());
            playerPoints = playerPoints.put(player, sources.append((Object)new ScoreEventSource(bonusPoints2.getPoints(), bonusPoints2.getFollower(), bonusPoints2.getSource())));
        }
        for (Tuple2 tuple2 : playerPoints) {
            Player player = (Player)tuple2._1;
            sources = (List<ScoreEventSource>)tuple2._2;
            Follower sample = (Follower)sources.filter(s -> s.getFollower() != null).map(ScoreEventSource::getFollower).getOrNull();
            if (sample == null) {
                sample = this.feature.getSampleFollower(state, player);
            }
            for (ScoreEventSource scoreEventSource : sources.filter(s -> s.getFollower() == null)) {
                scoreEventSource.setFollower(sample);
            }
            for (Tuple2 tuple22 : sources.groupBy(ScoreEventSource::getFollower)) {
                Follower follower = (Follower)tuple22._1;
                LinearSeq pointValues = ((List)tuple22._2).map(ScoreEventSource::getPoints);
                int points = pointValues.sum().intValue();
                String label = String.join((CharSequence)" + ", pointValues.map(Objects::toString));
                ScoreEvent scoreEvent = new ScoreEvent(points, label, pointCategory, this.isFinal, follower.getDeployment(state), follower);
                List<Position> source = ((ScoreEventSource)((List)tuple22._2).get()).getSource();
                if (source != null) {
                    scoreEvent = scoreEvent.setSource(source);
                }
                state = state.appendEvent(scoreEvent);
            }
        }
        return state;
    }

    @Override
    public Scoreable getFeature() {
        return this.feature;
    }

    @Override
    public Set<Player> getOwners() {
        return this.owners;
    }

    static class ScoreEventSource {
        private int points;
        private Follower follower;
        private List<Position> source;

        public ScoreEventSource(int points, Follower follower, List<Position> source) {
            this.points = points;
            this.follower = follower;
            this.source = source;
        }

        public int getPoints() {
            return this.points;
        }

        public void setPoints(int points) {
            this.points = points;
        }

        public Follower getFollower() {
            return this.follower;
        }

        public void setFollower(Follower follower) {
            this.follower = follower;
        }

        public List<Position> getSource() {
            return this.source;
        }

        public void setSource(List<Position> source) {
            this.source = source;
        }
    }
}

