/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui;

import com.jcloisterzone.Expansion;
import com.jcloisterzone.ai.AiPlayer;
import com.jcloisterzone.board.TilePack;
import com.jcloisterzone.config.Config;
import com.jcloisterzone.debug.ForcedDrawTilePack;
import com.jcloisterzone.event.ChatEvent;
import com.jcloisterzone.event.ClientListChangedEvent;
import com.jcloisterzone.event.GameListChangedEvent;
import com.jcloisterzone.event.setup.CapabilityChangeEvent;
import com.jcloisterzone.event.setup.ExpansionChangedEvent;
import com.jcloisterzone.event.setup.PlayerSlotChangeEvent;
import com.jcloisterzone.event.setup.RuleChangeEvent;
import com.jcloisterzone.game.Capability;
import com.jcloisterzone.game.Game;
import com.jcloisterzone.game.GameSetup;
import com.jcloisterzone.game.PlayerSlot;
import com.jcloisterzone.game.Rule;
import com.jcloisterzone.online.Channel;
import com.jcloisterzone.ui.ChannelController;
import com.jcloisterzone.ui.Client;
import com.jcloisterzone.ui.EventProxyUiController;
import com.jcloisterzone.ui.GameController;
import com.jcloisterzone.ui.I18nUtils;
import com.jcloisterzone.ui.view.ChannelView;
import com.jcloisterzone.ui.view.GameSetupView;
import com.jcloisterzone.wsio.Connection;
import com.jcloisterzone.wsio.MessageDispatcher;
import com.jcloisterzone.wsio.MessageListener;
import com.jcloisterzone.wsio.WebSocketConnection;
import com.jcloisterzone.wsio.WsSubscribe;
import com.jcloisterzone.wsio.message.ChannelMessage;
import com.jcloisterzone.wsio.message.ChatMessage;
import com.jcloisterzone.wsio.message.ClientUpdateMessage;
import com.jcloisterzone.wsio.message.ErrorMessage;
import com.jcloisterzone.wsio.message.GameMessage;
import com.jcloisterzone.wsio.message.GameSetupMessage;
import com.jcloisterzone.wsio.message.GameUpdateMessage;
import com.jcloisterzone.wsio.message.SetCapabilityMessage;
import com.jcloisterzone.wsio.message.SetExpansionMessage;
import com.jcloisterzone.wsio.message.SetRuleMessage;
import com.jcloisterzone.wsio.message.SlotMessage;
import com.jcloisterzone.wsio.message.StartGameMessage;
import com.jcloisterzone.wsio.message.SyncGameMessage;
import com.jcloisterzone.wsio.message.TakeSlotMessage;
import com.jcloisterzone.wsio.message.UndoMessage;
import com.jcloisterzone.wsio.message.WsChainedMessage;
import com.jcloisterzone.wsio.message.WsInChannelMessage;
import com.jcloisterzone.wsio.message.WsInGameMessage;
import com.jcloisterzone.wsio.message.WsMessage;
import com.jcloisterzone.wsio.message.WsReplayableMessage;
import com.jcloisterzone.wsio.server.RemoteClient;
import io.vavr.collection.HashSet;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientMessageListener
implements MessageListener {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private WebSocketConnection conn;
    private MessageDispatcher dispatcher = new MessageDispatcher();
    private Map<String, GameController> gameControllers = new HashMap<String, GameController>();
    private Map<String, ChannelController> channelControllers = new HashMap<String, ChannelController>();
    private final boolean playOnline;
    private final Client client;
    private boolean autostartPerfomed;

    public ClientMessageListener(Client client, boolean playOnline) {
        this.client = client;
        this.playOnline = playOnline;
    }

    public WebSocketConnection connect(String username, URI uri) {
        this.conn = new WebSocketConnection(username, this.client.getConfig(), uri, this);
        return this.conn;
    }

    public boolean isPlayOnline() {
        return this.playOnline;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public Map<String, ChannelController> getChannelControllers() {
        return this.channelControllers;
    }

    public List<GameController> getGameControllers(String channel) {
        ArrayList<GameController> gcs = new ArrayList<GameController>();
        for (GameController gc : this.gameControllers.values()) {
            if (!gc.getChannel().equals(channel)) continue;
            gcs.add(gc);
        }
        return gcs;
    }

    @Override
    public void onWebsocketError(Exception ex) {
        this.client.onWebsocketError(ex);
    }

    @Override
    public void onWebsocketClose(int code, String reason, boolean remote) {
        this.client.onWebsocketClose(code, reason, remote);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onWebsocketMessage(WsMessage msg) {
        EventProxyUiController<?> controller = this.getController(msg);
        if (controller instanceof GameController) {
            GameController gc = (GameController)controller;
            try {
                gc.getActionLock().set(true);
                if (msg instanceof WsChainedMessage) {
                    String parentId = ((WsChainedMessage)((Object)msg)).getParentId();
                    String chainMessageId = gc.getChainMessageIdRef().get();
                    if (chainMessageId != null && !chainMessageId.equals(parentId)) {
                        this.logger.info("Unexpected game id. Expected {}, received {}", (Object)chainMessageId, (Object)parentId);
                        this.conn.send(new SyncGameMessage(gc.getGame().getGameId()));
                        return;
                    }
                    gc.getChainMessageIdRef().set(msg.getMessageId());
                }
                Game game = gc.getGame();
                this.dispatcher.dispatch(msg, this.conn, this, game);
            }
            finally {
                gc.getActionLock().set(false);
            }
        } else {
            this.dispatcher.dispatch(msg, this.conn, this);
        }
    }

    public RemoteClient getClientBySessionId(EventProxyUiController<?> controller, String sessionId) {
        if (sessionId == null) {
            return null;
        }
        for (RemoteClient remote : controller.getRemoteClients()) {
            if (!remote.getSessionId().equals(sessionId)) continue;
            return remote;
        }
        throw new NoSuchElementException();
    }

    private EventProxyUiController<?> getController(WsMessage msg) {
        ChannelController cc;
        GameController gc;
        if (msg instanceof WsInGameMessage && (gc = this.gameControllers.get(((WsInGameMessage)msg).getGameId())) != null) {
            return gc;
        }
        if (msg instanceof WsInChannelMessage && (cc = this.channelControllers.get(((WsInChannelMessage)msg).getChannel())) != null) {
            return cc;
        }
        return null;
    }

    private Game getGame(WsInGameMessage msg) {
        GameController gc = (GameController)this.getController(msg);
        return gc == null ? null : gc.getGame();
    }

    private void updateSlot(PlayerSlot[] slots, SlotMessage slotMsg) {
        PlayerSlot slot = slots[slotMsg.getNumber()];
        slot.setNickname(slotMsg.getNickname());
        slot.setSessionId(slotMsg.getSessionId());
        slot.setClientId(slotMsg.getClientId());
        if (slotMsg.getClientId() == null) {
            slot.setState(PlayerSlot.SlotState.OPEN);
        } else {
            slot.setState(this.conn.getSessionId().equals(slotMsg.getSessionId()) ? PlayerSlot.SlotState.OWN : PlayerSlot.SlotState.REMOTE);
        }
        slot.setSerial(slotMsg.getSerial());
        slot.setAiClassName(slotMsg.getAiClassName());
    }

    private void createGameSlots(GameController gc, GameMessage msg) {
        PlayerSlot[] slots = new PlayerSlot[6];
        for (SlotMessage slotMsg : msg.getSlots()) {
            int number = slotMsg.getNumber();
            PlayerSlot slot = new PlayerSlot(number);
            slot.setColors(this.client.getConfig().getPlayerColor(slot));
            slots[number] = slot;
            this.updateSlot(slots, slotMsg);
        }
        gc.getGame().setSlots(slots);
    }

    private GameController createGameController(GameMessage msg) {
        Game game = new Game(msg.getGameId(), msg.getInitialSeed());
        game.setName(msg.getName());
        GameController gc = new GameController(this.client, game);
        game.setConnection(gc.getConnection());
        gc.setReportingTool(this.conn.getReportingTool());
        gc.setChannel(msg.getChannel());
        gc.setPasswordProtected(msg.isPasswordProtected());
        if (msg instanceof ChannelMessage.ChannelMessageGame) {
            for (RemoteClient client : ((ChannelMessage.ChannelMessageGame)msg).getClients()) {
                if (client.getState() == null) {
                    client.setState(ClientUpdateMessage.ClientState.ACTIVE);
                }
                gc.getRemoteClients().add(client);
            }
        }
        if (msg.getSlots() != null) {
            this.createGameSlots(gc, msg);
        }
        return gc;
    }

    private void handleGameStarted(GameController gc, long clockStart, io.vavr.collection.List<WsReplayableMessage> replay) throws InvocationTargetException, InterruptedException {
        this.conn.getReportingTool().setGame(gc.getGame());
        HashMap<String, Object> annotations = gc.getClient().getSavedGameAnnotations();
        gc.getGame().setClockStart(clockStart);
        gc.getGame().start(gc, replay, annotations);
        if (!"false".equals(System.getProperty("showGameDebugModeInfo"))) {
            SwingUtilities.invokeLater(() -> {
                TilePack tilePack = gc.getGame().getState().getTilePack();
                if (!tilePack.getClass().equals(TilePack.class)) {
                    String msg = String.format("Game is running in debug mode and using %s tile pack.", tilePack.getClass().getSimpleName());
                    if (tilePack instanceof ForcedDrawTilePack) {
                        msg = String.format("%s Tiles: %s ...", msg, String.join((CharSequence)", ", ((ForcedDrawTilePack)tilePack).getDrawQueue().slice(0, 5)));
                    }
                    gc.getGameView().getGridPanel().showInfoMessage(msg, "GAME-IN-DEBUG-MODE");
                }
                if (gc.getGame().isCorrupted()) {
                    gc.getGameView().getGridPanel().showInfoMessage("Game state is inconsistent. Loaded with ignoring (possible) duplicate record. Anyway please provide saved game to farin@farin.cz to help improving app.", "GAME-INCONSISTENT");
                }
            });
        }
    }

    private void openGameSetup(GameController gc, GameMessage msg) throws InvocationTargetException, InterruptedException {
        SwingUtilities.invokeAndWait(() -> {
            this.client.mountView(new GameSetupView(this.client, gc, msg.getStatus() == GameMessage.GameStatus.OPEN));
            this.performAutostart(gc.getGame());
        });
    }

    @WsSubscribe
    public void handleGame(GameMessage msg) throws InvocationTargetException, InterruptedException {
        this.handleGame(msg, false);
    }

    public GameController handleGame(GameMessage msg, boolean channelList) throws InvocationTargetException, InterruptedException {
        GameController gc;
        msg.getGameSetup().setGameId(msg.getGameId());
        if (msg.getSlots() != null) {
            for (SlotMessage slotMsg : msg.getSlots()) {
                slotMsg.setGameId(msg.getGameId());
            }
        }
        if ((gc = (GameController)this.getController(msg)) == null) {
            ArrayList remoteClients = new ArrayList();
            gc = this.createGameController(msg);
            gc.getRemoteClients().addAll(remoteClients);
            this.gameControllers.put(msg.getGameId(), gc);
        }
        this.handleGameSetup(msg.getGameSetup());
        if (msg.getSlots() != null) {
            this.createGameSlots(gc, msg);
            for (SlotMessage slotMsg : msg.getSlots()) {
                this.handleSlot(slotMsg);
                gc.getGame().handleSlotMessage(slotMsg);
            }
        }
        gc.setGameStatus(msg.getStatus());
        gc.getChainMessageIdRef().set(null);
        if (!channelList) {
            switch (msg.getStatus()) {
                case OPEN: 
                case PAUSED: {
                    this.openGameSetup(gc, msg);
                    break;
                }
                case RUNNING: {
                    io.vavr.collection.List<Object> replay = msg.getReplay() == null ? io.vavr.collection.List.empty() : io.vavr.collection.List.ofAll(msg.getReplay());
                    this.handleGameStarted(gc, msg.getClockStart(), replay);
                }
            }
        }
        return gc;
    }

    @WsSubscribe
    public void handleChannel(ChannelMessage msg) throws InvocationTargetException, InterruptedException {
        Channel channel = new Channel(msg.getName());
        ChannelController channelController = new ChannelController(this.client, channel);
        channelController.getRemoteClients().addAll(Arrays.asList(msg.getClients()));
        this.channelControllers.clear();
        this.channelControllers.put(channel.getName(), channelController);
        SwingUtilities.invokeAndWait(() -> this.client.mountView(new ChannelView(this.client, channelController)));
        GameController[] gameControllers = new GameController[msg.getGames().length];
        int i = 0;
        for (ChannelMessage.ChannelMessageGame game : msg.getGames()) {
            game.setChannel(msg.getName());
            gameControllers[i++] = this.handleGame(game, true);
        }
        ((Channel)channelController.getEventProxy()).post(new GameListChangedEvent(gameControllers));
    }

    @WsSubscribe
    public void handleGameUpdate(GameUpdateMessage msg) throws InvocationTargetException, InterruptedException {
        GameController gc;
        msg.getGame().setChannel(msg.getChannel());
        GameMessage.GameStatus status = msg.getGame().getStatus();
        if (GameMessage.GameStatus.OPEN.equals((Object)status) || GameMessage.GameStatus.PAUSED.equals((Object)status)) {
            gc = (GameController)this.getController(msg.getGame());
            if (gc != null) {
                gc.setGameStatus(status);
                return;
            }
            this.handleGame(msg.getGame(), true);
        } else {
            if (GameMessage.GameStatus.RUNNING.equals((Object)status) && this.client.getView() instanceof GameSetupView && (gc = ((GameSetupView)this.client.getView()).getGameController()).getGame().getGameId().equals(msg.getGame().getGameId())) {
                gc.setGameStatus(status);
                return;
            }
            this.gameControllers.remove(msg.getGame().getGameId());
        }
        List<GameController> gcs = this.getGameControllers(msg.getChannel());
        ChannelController channelController = (ChannelController)this.getController(msg);
        ((Channel)channelController.getEventProxy()).post(new GameListChangedEvent(gcs.toArray(new GameController[gcs.size()])));
    }

    @WsSubscribe
    public void handleClientUpdate(ClientUpdateMessage msg) {
        EventProxyUiController<?> controller = this.getController(msg);
        if (controller != null) {
            RemoteClient rc = new RemoteClient(msg.getSessionId(), msg.getName(), msg.getState());
            List<RemoteClient> clients = controller.getRemoteClients();
            if (ClientUpdateMessage.ClientState.OFFLINE.equals((Object)msg.getState())) {
                clients.remove(rc);
            } else {
                int idx = clients.indexOf(rc);
                if (idx == -1) {
                    clients.add(rc);
                } else {
                    clients.set(idx, rc);
                }
            }
            ArrayList<RemoteClient> frozenList = new ArrayList<RemoteClient>(clients);
            controller.getEventProxy().post(new ClientListChangedEvent(frozenList));
        } else {
            this.logger.warn("No controller for message {}", (Object)msg);
        }
    }

    @WsSubscribe
    public void handleChat(ChatMessage msg) {
        EventProxyUiController<?> controller = this.getController(msg);
        if (controller != null) {
            ChatEvent ev = new ChatEvent(this.getClientBySessionId(controller, msg.getSessionId()), msg.getText());
            controller.getEventProxy().post(ev);
        } else {
            this.logger.warn("No controller for message {}", (Object)msg);
        }
    }

    @WsSubscribe
    public void handleSlot(SlotMessage msg) {
        Game game = this.getGame(msg);
        if (game != null) {
            PlayerSlot[] slots = game.getPlayerSlots();
            this.updateSlot(slots, msg);
            game.post(new PlayerSlotChangeEvent(slots[msg.getNumber()]));
        }
    }

    @WsSubscribe
    public void handleGameSetup(GameSetupMessage msg) {
        Game game = this.getGame(msg);
        if (game != null) {
            game.setSetup(new GameSetup(io.vavr.collection.HashMap.ofAll(msg.getExpansions()), HashSet.ofAll(msg.getCapabilities()), io.vavr.collection.HashMap.ofAll(msg.getRules())));
            for (Expansion exp : Expansion.values()) {
                game.post(new ExpansionChangedEvent(exp, game.getSetup().getExpansions().get(exp).getOrElse(0)));
            }
            for (Rule rule : Rule.values()) {
                Object value = game.getSetup().getRules().get(rule).getOrNull();
                game.post(new RuleChangeEvent(rule, value));
            }
        }
    }

    @WsSubscribe
    public void handleSetExpansion(SetExpansionMessage msg) {
        Game game = this.getGame(msg);
        if (game != null) {
            Expansion expansion = msg.getExpansion();
            int count = msg.getCount();
            game.mapSetup(setup -> setup.mapExpansions(expansions -> count > 0 ? expansions.put(expansion, count) : expansions.remove(expansion)));
            game.post(new ExpansionChangedEvent(expansion, count));
        }
    }

    @WsSubscribe
    public void handleSetRule(SetRuleMessage msg) {
        Game game = this.getGame(msg);
        if (game != null) {
            Rule rule = msg.getRule();
            Object value = msg.getValue();
            game.mapSetup(setup -> setup.mapRules(rules -> msg.getValue() == null ? rules.remove(rule) : rules.put(rule, value)));
            game.post(new RuleChangeEvent(rule, msg.getValue()));
        }
    }

    @WsSubscribe
    public void handleSetCapability(SetCapabilityMessage msg) {
        Game game = this.getGame(msg);
        if (game != null) {
            Class<? extends Capability<?>> cap = msg.getCapability();
            boolean enabled = msg.isEnabled();
            game.mapSetup(setup -> setup.mapCapabilities(caps -> enabled ? caps.add(cap) : caps.remove(cap)));
            game.post(new CapabilityChangeEvent(cap, enabled));
        }
    }

    @WsSubscribe
    public void handleUndo(UndoMessage msg) {
        Game game = this.getGame(msg);
        if (game != null) {
            game.undo();
        }
    }

    @WsSubscribe
    public void handleError(Connection conn, ErrorMessage err) {
        switch (err.getCode()) {
            case "badVersion": {
                this.logger.warn(err.getMessage());
                String msg = this.playOnline ? I18nUtils._tr("Online play server is not compatible with your application. Please upgrade JCloisterZone to the latest version.", new Object[0]) : I18nUtils._tr("Remote JCloisterZone is not compatible with local application. Please upgrade both applications to same version.", new Object[0]);
                JOptionPane.showMessageDialog(this.client, msg, I18nUtils._tr("Incompatible versions", new Object[0]), 0);
                break;
            }
            case "invalidPassword": {
                JOptionPane.showMessageDialog(this.client, I18nUtils._tr("Invalid password", new Object[0]), I18nUtils._tr("Invalid password", new Object[0]), 2);
            }
            default: {
                JOptionPane.showMessageDialog(this.client, err.getMessage(), "Error", 0);
            }
        }
    }

    public String getSessionId() {
        return this.conn.getSessionId();
    }

    /*
     * WARNING - void declaration
     */
    protected void performAutostart(Game game) {
        Config.DebugConfig debugConfig = this.client.getConfig().getDebug();
        if (!this.autostartPerfomed && debugConfig != null && debugConfig.isAutostartEnabled()) {
            List<Object> players;
            this.autostartPerfomed = true;
            Config.AutostartConfig autostartConfig = debugConfig.getAutostart();
            Config.PresetConfig presetCfg = this.client.getConfig().getPresets().get(autostartConfig.getPreset());
            if (presetCfg == null) {
                this.logger.warn("Autostart profile {} not found.", (Object)autostartConfig.getPreset());
                return;
            }
            List<Object> list = players = autostartConfig.getPlayers() == null ? new ArrayList() : autostartConfig.getPlayers();
            if (players.isEmpty()) {
                players.add("Player");
            }
            int i = 0;
            for (String string : players) {
                void var8_8;
                Class<?> clazz = null;
                PlayerSlot slot = game.getPlayerSlots()[i];
                try {
                    clazz = Class.forName(string);
                    slot.setAiClassName(string);
                    String string2 = "AI-" + i + "-" + clazz.getSimpleName().replace("AiPlayer", "");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                TakeSlotMessage msg = new TakeSlotMessage(i, (String)var8_8);
                msg.setGameId(game.getGameId());
                if (slot.getAiClassName() != null) {
                    msg.setAiClassName(slot.getAiClassName());
                    try {
                        AiPlayer aiPlayer = (AiPlayer)Class.forName(slot.getAiClassName()).newInstance();
                        msg.setSupportedSetup(aiPlayer.supportedSetup());
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        this.logger.error(e.getMessage(), e);
                    }
                }
                this.conn.send(msg);
                ++i;
            }
            presetCfg.updateGameSetup(this.conn, game.getGameId());
            StartGameMessage msg = new StartGameMessage();
            msg.setGameId(game.getGameId());
            this.conn.send(msg);
        }
    }
}

